/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.registry;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.registry.extension.repo.ExtensionRepoArtifact;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;

public class ExtensionRepoArtifactsResult
extends AbstractWritableResult<List<ExtensionRepoArtifact>> {
    private final List<ExtensionRepoArtifact> bundleArtifacts;

    public ExtensionRepoArtifactsResult(ResultType resultType, List<ExtensionRepoArtifact> bundleArtifacts) {
        super(resultType);
        this.bundleArtifacts = bundleArtifacts;
        Validate.notNull(this.bundleArtifacts);
        this.bundleArtifacts.sort(Comparator.comparing(ExtensionRepoArtifact::getBucketName).thenComparing(ExtensionRepoArtifact::getGroupId).thenComparing(ExtensionRepoArtifact::getArtifactId));
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        if (this.bundleArtifacts.isEmpty()) {
            return;
        }
        Table table = new Table.Builder().column("#", 3, 3, false).column("Bucket", 40, 400, false).column("Group", 40, 200, false).column("Artifact", 40, 200, false).build();
        for (int i = 0; i < this.bundleArtifacts.size(); ++i) {
            ExtensionRepoArtifact artifact = this.bundleArtifacts.get(i);
            table.addRow(String.valueOf(i + 1), artifact.getBucketName(), artifact.getGroupId(), artifact.getArtifactId());
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }

    @Override
    public List<ExtensionRepoArtifact> getResult() {
        return this.bundleArtifacts;
    }
}

