/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.PrintStream;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.dto.RegistryDTO;
import org.apache.nifi.web.api.entity.RegistryClientEntity;
import org.apache.nifi.web.api.entity.RegistryClientsEntity;

public class RegistryClientsResult
extends AbstractWritableResult<RegistryClientsEntity> {
    final RegistryClientsEntity registryClients;

    public RegistryClientsResult(ResultType resultType, RegistryClientsEntity registryClients) {
        super(resultType);
        this.registryClients = registryClients;
        Validate.notNull((Object)this.registryClients);
    }

    @Override
    public RegistryClientsEntity getResult() {
        return this.registryClients;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) {
        Set clients = this.registryClients.getRegistries();
        if (clients == null || clients.isEmpty()) {
            return;
        }
        List registries = clients.stream().map(RegistryClientEntity::getComponent).sorted(Comparator.comparing(RegistryDTO::getName)).collect(Collectors.toList());
        Table table = new Table.Builder().column("#", 3, 3, false).column("Name", 20, 36, true).column("Id", 36, 36, false).column("Uri", 3, Integer.MAX_VALUE, false).build();
        for (int i = 0; i < registries.size(); ++i) {
            RegistryDTO r = (RegistryDTO)registries.get(i);
            table.addRow("" + (i + 1), r.getName(), r.getId(), r.getUri());
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }
}

