/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.dto.ParameterDTO;
import org.apache.nifi.web.api.entity.ParameterContextEntity;

public class ParamContextResult
extends AbstractWritableResult<ParameterContextEntity> {
    private final ParameterContextEntity parameterContext;

    public ParamContextResult(ResultType resultType, ParameterContextEntity parameterContext) {
        super(resultType);
        this.parameterContext = parameterContext;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        ParameterContextDTO parameterContextDTO = this.parameterContext.getComponent();
        Set paramEntities = parameterContextDTO.getParameters() == null ? Collections.emptySet() : parameterContextDTO.getParameters();
        Set paramDTOs = paramEntities.stream().map(p -> p.getParameter()).collect(Collectors.toSet());
        List sortedParams = paramDTOs.stream().sorted(Comparator.comparing(ParameterDTO::getName)).collect(Collectors.toList());
        Table table = new Table.Builder().column("#", 3, 3, false).column("Name", 20, 60, false).column("Value", 20, 80, false).column("Sensitive", 10, 10, false).column("Description", 20, 80, true).build();
        for (int i = 0; i < sortedParams.size(); ++i) {
            ParameterDTO r = (ParameterDTO)sortedParams.get(i);
            table.addRow(String.valueOf(i + 1), r.getName(), r.getValue(), r.getSensitive().toString(), r.getDescription());
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }

    @Override
    public ParameterContextEntity getResult() {
        return this.parameterContext;
    }
}

