/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.flow;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.registry.client.FlowSnapshotClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.result.registry.VersionedFlowSnapshotMetadataResult;

public class ListFlowVersions
extends AbstractNiFiRegistryCommand<VersionedFlowSnapshotMetadataResult> {
    public ListFlowVersions() {
        super("list-flow-versions", VersionedFlowSnapshotMetadataResult.class);
    }

    @Override
    public String getDescription() {
        return "Lists all of the flows for the given bucket.";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.FLOW_ID.createOption());
    }

    @Override
    public VersionedFlowSnapshotMetadataResult doExecute(NiFiRegistryClient client, Properties properties) throws ParseException, IOException, NiFiRegistryException {
        String flow = this.getRequiredArg(properties, CommandOption.FLOW_ID);
        FlowSnapshotClient snapshotClient = client.getFlowSnapshotClient();
        List snapshotMetadata = snapshotClient.getSnapshotMetadata(flow);
        return new VersionedFlowSnapshotMetadataResult(this.getResultType(properties), snapshotMetadata);
    }
}

