/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.client.FlowSnapshotClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.toolkit.cli.api.ClientFactory;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Result;
import org.apache.nifi.toolkit.cli.impl.command.AbstractPropertyCommand;
import org.apache.nifi.toolkit.cli.impl.session.SessionVariable;

public abstract class AbstractNiFiRegistryCommand<R extends Result>
extends AbstractPropertyCommand<R> {
    public AbstractNiFiRegistryCommand(String name, Class<R> resultClass) {
        super(name, resultClass);
    }

    @Override
    protected SessionVariable getPropertiesSessionVariable() {
        return SessionVariable.NIFI_REGISTRY_CLIENT_PROPS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final R doExecute(Properties properties) throws CommandException {
        ClientFactory<NiFiRegistryClient> clientFactory = this.getContext().getNiFiRegistryClientFactory();
        try (NiFiRegistryClient client = clientFactory.createClient(properties);){
            R r = this.doExecute(client, properties);
            return r;
        }
        catch (Exception e) {
            throw new CommandException("Error executing command '" + this.getName() + "' : " + e.getMessage(), e);
        }
    }

    public abstract R doExecute(NiFiRegistryClient var1, Properties var2) throws IOException, NiFiRegistryException, ParseException;

    protected List<Integer> getVersions(NiFiRegistryClient client, String flowId) throws NiFiRegistryException, IOException {
        FlowSnapshotClient srcSnapshotClient = client.getFlowSnapshotClient();
        List srcVersionMetadata = srcSnapshotClient.getSnapshotMetadata(flowId);
        return srcVersionMetadata.stream().map(s -> s.getVersion()).collect(Collectors.toList());
    }

    protected NiFiRegistryClient getSourceClient(NiFiRegistryClient client, String srcPropsValue) throws IOException, MissingOptionException {
        NiFiRegistryClient srcClient;
        if (!StringUtils.isBlank((CharSequence)srcPropsValue)) {
            Properties srcProps = new Properties();
            try (FileInputStream in = new FileInputStream(srcPropsValue);){
                srcProps.load(in);
            }
            ClientFactory<NiFiRegistryClient> clientFactory = this.getContext().getNiFiRegistryClientFactory();
            srcClient = clientFactory.createClient(srcProps);
        } else {
            srcClient = client;
        }
        return srcClient;
    }
}

