/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.registry;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.web.api.dto.RegistryDTO;
import org.apache.nifi.web.api.entity.RegistryClientEntity;

public class CreateRegistryClient
extends AbstractNiFiCommand<StringResult> {
    public CreateRegistryClient() {
        super("create-reg-client", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Creates a registry client using the provided information.";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.REGISTRY_CLIENT_NAME.createOption());
        this.addOption(CommandOption.REGISTRY_CLIENT_URL.createOption());
        this.addOption(CommandOption.REGISTRY_CLIENT_DESC.createOption());
    }

    @Override
    public StringResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException {
        String name = this.getRequiredArg(properties, CommandOption.REGISTRY_CLIENT_NAME);
        String url = this.getRequiredArg(properties, CommandOption.REGISTRY_CLIENT_URL);
        String desc = this.getArg(properties, CommandOption.REGISTRY_CLIENT_DESC);
        RegistryDTO registryDTO = new RegistryDTO();
        registryDTO.setName(name);
        registryDTO.setUri(url);
        registryDTO.setDescription(desc);
        RegistryClientEntity clientEntity = new RegistryClientEntity();
        clientEntity.setComponent(registryDTO);
        clientEntity.setRevision(this.getInitialRevisionDTO());
        RegistryClientEntity createdEntity = client.getControllerClient().createRegistryClient(clientEntity);
        return new StringResult(createdEntity.getId(), this.getContext().isInteractive());
    }
}

