/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg.cs;

import java.io.IOException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.FlowClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.nifi.pg.cs.ControllerServiceStateCounts;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.ControllerServicesEntity;

public class ControllerServiceUtil {
    public static ControllerServiceStateCounts getControllerServiceStates(FlowClient flowClient, String pgId) throws NiFiClientException, IOException {
        ControllerServicesEntity servicesEntity = flowClient.getControllerServices(pgId);
        return ControllerServiceUtil.getControllerServiceStates(servicesEntity);
    }

    public static ControllerServiceStateCounts getControllerServiceStates(ControllerServicesEntity servicesEntity) throws NiFiClientException {
        ControllerServiceStateCounts states = new ControllerServiceStateCounts();
        if (servicesEntity == null || servicesEntity.getControllerServices() == null || servicesEntity.getControllerServices().isEmpty()) {
            return states;
        }
        block12: for (ControllerServiceEntity serviceEntity : servicesEntity.getControllerServices()) {
            String state;
            switch (state = serviceEntity.getComponent().getState()) {
                case "ENABLED": {
                    states.incrementEnabled();
                    continue block12;
                }
                case "ENABLING": {
                    states.incrementEnabling();
                    continue block12;
                }
                case "DISABLED": {
                    states.incrementDisabled();
                    continue block12;
                }
                case "DISABLING": {
                    states.incrementDisabling();
                    continue block12;
                }
            }
            throw new NiFiClientException("Unexpected controller service state: " + state);
        }
        return states;
    }
}

