/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.params;

import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ParamContextClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.params.AbstractUpdateParamContextCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.dto.ParameterDTO;
import org.apache.nifi.web.api.entity.ParameterContextEntity;
import org.apache.nifi.web.api.entity.ParameterContextUpdateRequestEntity;
import org.apache.nifi.web.api.entity.ParameterEntity;

public class SetParam
extends AbstractUpdateParamContextCommand<VoidResult> {
    public SetParam() {
        super("set-param", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Creates or updates a parameter in the given parameter context.";
    }

    @Override
    protected void doInitialize(Context context) {
        super.doInitialize(context);
        this.addOption(CommandOption.PARAM_CONTEXT_ID.createOption());
        this.addOption(CommandOption.PARAM_NAME.createOption());
        this.addOption(CommandOption.PARAM_DESC.createOption());
        this.addOption(CommandOption.PARAM_VALUE.createOption());
        this.addOption(CommandOption.PARAM_SENSITIVE.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String paramContextId = this.getRequiredArg(properties, CommandOption.PARAM_CONTEXT_ID);
        String paramName = this.getRequiredArg(properties, CommandOption.PARAM_NAME);
        String paramValue = this.getArg(properties, CommandOption.PARAM_VALUE);
        String paramDesc = this.getArg(properties, CommandOption.PARAM_DESC);
        String paramSensitive = this.getArg(properties, CommandOption.PARAM_SENSITIVE);
        if (!(StringUtils.isBlank((CharSequence)paramSensitive) || "true".equals(paramSensitive) || "false".equals(paramSensitive))) {
            throw new IllegalArgumentException("Parameter sensitive flag must be one of 'true' or 'false'");
        }
        ParamContextClient paramContextClient = client.getParamContextClient();
        ParameterContextEntity existingParameterContextEntity = paramContextClient.getParamContext(paramContextId);
        ParameterContextDTO existingParameterContextDTO = existingParameterContextEntity.getComponent();
        Optional<ParameterDTO> existingParam = existingParameterContextDTO.getParameters().stream().map(p -> p.getParameter()).filter(p -> p.getName().equals(paramName)).findFirst();
        if (!existingParam.isPresent() && paramValue == null) {
            throw new IllegalArgumentException("A parameter value is required when creating a new parameter");
        }
        ParameterDTO parameterDTO = existingParam.isPresent() ? existingParam.get() : new ParameterDTO();
        parameterDTO.setName(paramName);
        if (paramValue != null) {
            parameterDTO.setValue(paramValue);
        }
        if (paramDesc != null) {
            parameterDTO.setDescription(paramDesc);
        }
        if (!StringUtils.isBlank((CharSequence)paramSensitive)) {
            parameterDTO.setSensitive(Boolean.valueOf(paramSensitive));
        }
        ParameterEntity parameterEntity = new ParameterEntity();
        parameterEntity.setParameter(parameterDTO);
        ParameterContextDTO parameterContextDTO = new ParameterContextDTO();
        parameterContextDTO.setId(existingParameterContextEntity.getId());
        parameterContextDTO.setParameters(Collections.singleton(parameterEntity));
        ParameterContextEntity updatedParameterContextEntity = new ParameterContextEntity();
        updatedParameterContextEntity.setId(paramContextId);
        updatedParameterContextEntity.setComponent(parameterContextDTO);
        updatedParameterContextEntity.setRevision(existingParameterContextEntity.getRevision());
        ParameterContextUpdateRequestEntity updateRequestEntity = paramContextClient.updateParamContext(updatedParameterContextEntity);
        this.performUpdate(paramContextClient, updatedParameterContextEntity, updateRequestEntity);
        if (this.isInteractive()) {
            this.println();
        }
        return VoidResult.getInstance();
    }
}

