/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.params;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ParamContextClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.params.AbstractUpdateParamContextCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.toolkit.cli.impl.util.JacksonUtils;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.dto.ParameterDTO;
import org.apache.nifi.web.api.entity.ParameterContextEntity;
import org.apache.nifi.web.api.entity.ParameterContextUpdateRequestEntity;
import org.apache.nifi.web.api.entity.ParameterEntity;

public class MergeParamContext
extends AbstractUpdateParamContextCommand<VoidResult> {
    public MergeParamContext() {
        super("merge-param-context", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Adds any parameters that exist in the exported context that don't exist in the existing context.";
    }

    @Override
    protected void doInitialize(Context context) {
        super.doInitialize(context);
        this.addOption(CommandOption.PARAM_CONTEXT_ID.createOption());
        this.addOption(CommandOption.INPUT_SOURCE.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        ParamContextClient paramContextClient;
        ParameterContextEntity existingContextEntity;
        ParameterContextDTO existingContext;
        String existingContextId = this.getRequiredArg(properties, CommandOption.PARAM_CONTEXT_ID);
        String inputSource = this.getRequiredArg(properties, CommandOption.INPUT_SOURCE);
        String paramContextJson = this.getInputSourceContent(inputSource);
        ObjectMapper objectMapper = JacksonUtils.getObjectMapper();
        ParameterContextDTO incomingContext = (ParameterContextDTO)objectMapper.readValue(paramContextJson, ParameterContextDTO.class);
        if (incomingContext.getParameters() == null) {
            incomingContext.setParameters(new LinkedHashSet());
        }
        if ((existingContext = (existingContextEntity = (paramContextClient = client.getParamContextClient()).getParamContext(existingContextId)).getComponent()).getParameters() == null) {
            existingContext.setParameters(new LinkedHashSet());
        }
        LinkedHashSet<ParameterEntity> createdParameters = new LinkedHashSet<ParameterEntity>();
        for (ParameterEntity incomingParameterEntity : incomingContext.getParameters()) {
            ParameterDTO incomingParameter = incomingParameterEntity.getParameter();
            String parameterName = incomingParameter.getName();
            Optional<ParameterDTO> existingParameter = existingContext.getParameters().stream().map(p -> p.getParameter()).filter(p -> p.getName().equals(parameterName)).findFirst();
            if (existingParameter.isPresent()) continue;
            ParameterEntity createdParam = this.createParameter(incomingParameter);
            createdParameters.add(createdParam);
        }
        ParameterContextDTO updatedContextDto = new ParameterContextDTO();
        updatedContextDto.setId(existingContext.getId());
        updatedContextDto.setParameters(createdParameters);
        ParameterContextEntity updatedContextEntity = new ParameterContextEntity();
        updatedContextEntity.setId(existingContext.getId());
        updatedContextEntity.setComponent(updatedContextDto);
        updatedContextEntity.setRevision(existingContextEntity.getRevision());
        ParameterContextUpdateRequestEntity updateRequestEntity = paramContextClient.updateParamContext(updatedContextEntity);
        this.performUpdate(paramContextClient, updatedContextEntity, updateRequestEntity);
        this.printlnIfInteractive("");
        return VoidResult.getInstance();
    }

    private ParameterEntity createParameter(ParameterDTO incomingParam) throws CommandException {
        String parameterName = incomingParam.getName();
        this.printlnIfInteractive("Found parameter to add - '" + parameterName + "'");
        ParameterDTO newParameter = new ParameterDTO();
        newParameter.setName(incomingParam.getName());
        newParameter.setDescription(incomingParam.getDescription());
        newParameter.setSensitive(incomingParam.getSensitive());
        newParameter.setValue(incomingParam.getValue());
        ParameterEntity newParameterEntity = new ParameterEntity();
        newParameterEntity.setParameter(newParameter);
        return newParameterEntity;
    }
}

