/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.params;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ParamContextClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.web.api.entity.ParameterContextEntity;

public class DeleteParamContext
extends AbstractNiFiCommand<StringResult> {
    public DeleteParamContext() {
        super("delete-param-context", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Deletes a parameter context.";
    }

    @Override
    protected void doInitialize(Context context) {
        super.doInitialize(context);
        this.addOption(CommandOption.PARAM_CONTEXT_ID.createOption());
    }

    @Override
    public StringResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String paramContextId = this.getRequiredArg(properties, CommandOption.PARAM_CONTEXT_ID);
        ParamContextClient paramContextClient = client.getParamContextClient();
        ParameterContextEntity existingParamContext = paramContextClient.getParamContext(paramContextId);
        String version = String.valueOf(existingParamContext.getRevision().getVersion());
        paramContextClient.deleteParamContext(paramContextId, version);
        return new StringResult(paramContextId, this.isInteractive());
    }
}

