/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.params;

import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ParamContextClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.params.AbstractUpdateParamContextCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.dto.ParameterDTO;
import org.apache.nifi.web.api.entity.ParameterContextEntity;
import org.apache.nifi.web.api.entity.ParameterContextUpdateRequestEntity;
import org.apache.nifi.web.api.entity.ParameterEntity;

public class DeleteParam
extends AbstractUpdateParamContextCommand<VoidResult> {
    public DeleteParam() {
        super("delete-param", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Deletes a given parameter from the given parameter context.";
    }

    @Override
    protected void doInitialize(Context context) {
        super.doInitialize(context);
        this.addOption(CommandOption.PARAM_CONTEXT_ID.createOption());
        this.addOption(CommandOption.PARAM_NAME.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String paramContextId = this.getRequiredArg(properties, CommandOption.PARAM_CONTEXT_ID);
        String paramName = this.getRequiredArg(properties, CommandOption.PARAM_NAME);
        ParamContextClient paramContextClient = client.getParamContextClient();
        ParameterContextEntity existingEntity = paramContextClient.getParamContext(paramContextId);
        Optional<ParameterDTO> existingParam = existingEntity.getComponent().getParameters().stream().map(p -> p.getParameter()).filter(p -> p.getName().equals(paramName)).findFirst();
        if (!existingParam.isPresent()) {
            throw new NiFiClientException("Unable to delete parameter, no parameter found with name '" + paramName + "'");
        }
        ParameterDTO parameterDTO = existingParam.get();
        parameterDTO.setValue(null);
        parameterDTO.setDescription(null);
        parameterDTO.setSensitive(null);
        ParameterEntity parameterEntity = new ParameterEntity();
        parameterEntity.setParameter(parameterDTO);
        ParameterContextDTO parameterContextDTO = new ParameterContextDTO();
        parameterContextDTO.setId(existingEntity.getId());
        parameterContextDTO.setParameters(Collections.singleton(parameterEntity));
        ParameterContextEntity updatedParameterContextEntity = new ParameterContextEntity();
        updatedParameterContextEntity.setId(paramContextId);
        updatedParameterContextEntity.setComponent(parameterContextDTO);
        updatedParameterContextEntity.setRevision(existingEntity.getRevision());
        ParameterContextUpdateRequestEntity updateRequestEntity = paramContextClient.updateParamContext(updatedParameterContextEntity);
        this.performUpdate(paramContextClient, updatedParameterContextEntity, updateRequestEntity);
        if (this.isInteractive()) {
            this.println();
        }
        return VoidResult.getInstance();
    }
}

