/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.toolkit.cli.api.Command;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.api.Result;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;

public abstract class AbstractCommand<R extends Result>
implements Command<R> {
    private final String name;
    private final Class<R> resultClass;
    private final Options options;
    private Context context;
    private PrintStream output;

    public AbstractCommand(String name, Class<R> resultClass) {
        this.name = name;
        this.resultClass = resultClass;
        Validate.notNull((Object)this.name);
        Validate.notNull(this.resultClass);
        this.options = this.createBaseOptions();
        Validate.notNull((Object)this.options);
    }

    protected Options createBaseOptions() {
        Options options = new Options();
        options.addOption(CommandOption.URL.createOption());
        options.addOption(CommandOption.PROPERTIES.createOption());
        options.addOption(CommandOption.KEYSTORE.createOption());
        options.addOption(CommandOption.KEYSTORE_TYPE.createOption());
        options.addOption(CommandOption.KEYSTORE_PASSWORD.createOption());
        options.addOption(CommandOption.KEY_PASSWORD.createOption());
        options.addOption(CommandOption.TRUSTSTORE.createOption());
        options.addOption(CommandOption.TRUSTSTORE_TYPE.createOption());
        options.addOption(CommandOption.TRUSTSTORE_PASSWORD.createOption());
        options.addOption(CommandOption.PROXIED_ENTITY.createOption());
        options.addOption(CommandOption.OUTPUT_TYPE.createOption());
        options.addOption(CommandOption.VERBOSE.createOption());
        options.addOption(CommandOption.HELP.createOption());
        return options;
    }

    @Override
    public final void initialize(Context context) {
        Validate.notNull((Object)context);
        Validate.notNull((Object)context.getOutput());
        this.context = context;
        this.output = context.getOutput();
        this.doInitialize(context);
    }

    protected void doInitialize(Context context) {
    }

    protected void addOption(Option option) {
        this.options.addOption(option);
    }

    protected Context getContext() {
        return this.context;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Class<R> getResultImplType() {
        return this.resultClass;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public void printUsage(String errorMessage) {
        this.output.println();
        if (errorMessage != null) {
            this.output.println("ERROR: " + errorMessage);
            this.output.println();
        }
        PrintWriter printWriter = new PrintWriter(this.output);
        int width = 80;
        HelpFormatter hf = new HelpFormatter();
        hf.setWidth(80);
        hf.printWrapped(printWriter, 80, this.getDescription());
        hf.printWrapped(printWriter, 80, "");
        if (this.isReferencable()) {
            hf.printWrapped(printWriter, 80, "PRODUCES BACK-REFERENCES");
            hf.printWrapped(printWriter, 80, "");
        }
        hf.printHelp(printWriter, hf.getWidth(), this.getName(), null, this.getOptions(), hf.getLeftPadding(), hf.getDescPadding(), null, false);
        printWriter.println();
        printWriter.flush();
    }

    protected void print(String val) {
        this.output.print(val);
    }

    protected void println(String val) {
        this.output.println(val);
    }

    protected void println() {
        this.output.println();
    }

    protected ResultType getResultType(Properties properties) {
        ResultType resultType;
        if (properties.containsKey(CommandOption.OUTPUT_TYPE.getLongName())) {
            String outputTypeValue = properties.getProperty(CommandOption.OUTPUT_TYPE.getLongName());
            resultType = ResultType.valueOf(outputTypeValue.toUpperCase().trim());
        } else {
            resultType = ResultType.SIMPLE;
        }
        return resultType;
    }

    protected String getArg(Properties properties, CommandOption option) {
        return properties.getProperty(option.getLongName());
    }

    protected String getRequiredArg(Properties properties, CommandOption option) throws MissingOptionException {
        String argValue = properties.getProperty(option.getLongName());
        if (StringUtils.isBlank((CharSequence)argValue)) {
            throw new MissingOptionException("Missing required option --" + option.getLongName());
        }
        return argValue;
    }

    protected Integer getIntArg(Properties properties, CommandOption option) throws MissingOptionException {
        String argValue = properties.getProperty(option.getLongName());
        if (StringUtils.isBlank((CharSequence)argValue)) {
            return null;
        }
        try {
            return Integer.valueOf(argValue);
        }
        catch (Exception e) {
            throw new MissingOptionException("Version must be numeric: " + argValue);
        }
    }

    protected Integer getRequiredIntArg(Properties properties, CommandOption option) throws MissingOptionException {
        String argValue = properties.getProperty(option.getLongName());
        if (StringUtils.isBlank((CharSequence)argValue)) {
            throw new MissingOptionException("Missing required option --" + option.getLongName());
        }
        try {
            return Integer.valueOf(argValue);
        }
        catch (Exception e) {
            throw new MissingOptionException("Version must be numeric: " + argValue);
        }
    }

    protected boolean hasArg(Properties properties, CommandOption option) {
        return properties.containsKey(option.getLongName());
    }

    protected boolean isVerbose(Properties properties) {
        return properties.containsKey(CommandOption.VERBOSE.getLongName());
    }

    protected boolean isInteractive() {
        return this.getContext().isInteractive();
    }

    protected void printIfInteractive(String val) {
        if (this.isInteractive()) {
            this.print(val);
        }
    }

    protected void printlnIfInteractive(String val) {
        if (this.isInteractive()) {
            this.println(val);
        }
    }

    protected String getInputSourceContent(String inputFile) throws IOException {
        String contents;
        try {
            URL url = new URL(inputFile);
            contents = IOUtils.toString((URL)url, (Charset)StandardCharsets.UTF_8);
        }
        catch (MalformedURLException e) {
            URI uri = Paths.get(inputFile, new String[0]).toAbsolutePath().toUri();
            contents = IOUtils.toString((URI)uri, (Charset)StandardCharsets.UTF_8);
        }
        return contents;
    }
}

