/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client.nifi.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.client.WebTarget;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.TemplatesClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.AbstractJerseyClient;
import org.apache.nifi.web.api.dto.TemplateDTO;

public class JerseyTemplatesClient
extends AbstractJerseyClient
implements TemplatesClient {
    private final WebTarget templatesTarget;

    public JerseyTemplatesClient(WebTarget baseTarget) {
        this(baseTarget, Collections.emptyMap());
    }

    public JerseyTemplatesClient(WebTarget baseTarget, Map<String, String> headers) {
        super(headers);
        this.templatesTarget = baseTarget.path("/templates");
    }

    @Override
    public TemplateDTO getTemplate(String templateId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            throw new IllegalArgumentException("Template id cannot be null");
        }
        return this.executeAction("Error retrieving template", () -> {
            WebTarget target = this.templatesTarget.path("{id}/download").resolveTemplate("id", (Object)templateId);
            return (TemplateDTO)this.getRequestBuilder(target).get(TemplateDTO.class);
        });
    }
}

