/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client.nifi.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.RemoteProcessGroupClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.AbstractJerseyClient;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.entity.RemoteProcessGroupEntity;

public class JerseyRemoteProcessGroupClient
extends AbstractJerseyClient
implements RemoteProcessGroupClient {
    private final WebTarget processGroupTarget;
    private final WebTarget rpgTarget;

    public JerseyRemoteProcessGroupClient(WebTarget baseTarget) {
        this(baseTarget, Collections.emptyMap());
    }

    public JerseyRemoteProcessGroupClient(WebTarget baseTarget, Map<String, String> headers) {
        super(headers);
        this.processGroupTarget = baseTarget.path("/process-groups/{pgId}");
        this.rpgTarget = baseTarget.path("/remote-process-groups/{id}");
    }

    @Override
    public RemoteProcessGroupEntity createRemoteProcessGroup(String parentGroupId, RemoteProcessGroupEntity entity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)parentGroupId)) {
            throw new IllegalArgumentException("Parent process group id cannot be null or blank");
        }
        if (entity == null) {
            throw new IllegalArgumentException("Remote Process Group entity cannot be null");
        }
        return this.executeAction("Error creating Remote Process Group", () -> {
            WebTarget target = this.processGroupTarget.path("/remote-process-groups").resolveTemplate("pgId", (Object)parentGroupId);
            return (RemoteProcessGroupEntity)this.getRequestBuilder(target).post(Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE), RemoteProcessGroupEntity.class);
        });
    }

    @Override
    public RemoteProcessGroupEntity getRemoteProcessGroup(String id) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Remote Process Group ID cannot be null");
        }
        return this.executeAction("Error retrieving status of Remote Process Group", () -> {
            WebTarget target = this.rpgTarget.resolveTemplate("id", (Object)id);
            return (RemoteProcessGroupEntity)this.getRequestBuilder(target).get(RemoteProcessGroupEntity.class);
        });
    }

    @Override
    public RemoteProcessGroupEntity updateRemoteProcessGroup(RemoteProcessGroupEntity entity) throws NiFiClientException, IOException {
        if (entity == null) {
            throw new IllegalArgumentException("Remote Process Group entity cannot be null");
        }
        return this.executeAction("Error updating Remote Process Group", () -> {
            WebTarget target = this.rpgTarget.resolveTemplate("id", (Object)entity.getId());
            return (RemoteProcessGroupEntity)this.getRequestBuilder(target).put(Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE), RemoteProcessGroupEntity.class);
        });
    }

    @Override
    public RemoteProcessGroupEntity deleteRemoteProcessGroup(RemoteProcessGroupEntity entity) throws NiFiClientException, IOException {
        if (entity == null) {
            throw new IllegalArgumentException("Remote Process Group entity cannot be null");
        }
        if (entity.getId() == null) {
            throw new IllegalArgumentException("Remote Process Group ID cannot be null");
        }
        RevisionDTO revision = entity.getRevision();
        if (revision == null) {
            throw new IllegalArgumentException("Revision cannot be null");
        }
        return this.executeAction("Error deleting Remote Process Group", () -> {
            WebTarget target = this.rpgTarget.queryParam("version", new Object[]{revision.getVersion()}).queryParam("clientId", new Object[]{revision.getClientId()}).resolveTemplate("id", (Object)entity.getId());
            return (RemoteProcessGroupEntity)this.getRequestBuilder(target).delete(RemoteProcessGroupEntity.class);
        });
    }

    @Override
    public RemoteProcessGroupEntity startTransmitting(RemoteProcessGroupEntity entity) throws NiFiClientException, IOException {
        return this.updateTransmitting(entity, true);
    }

    @Override
    public RemoteProcessGroupEntity stopTransmitting(RemoteProcessGroupEntity entity) throws NiFiClientException, IOException {
        return this.updateTransmitting(entity, false);
    }

    private RemoteProcessGroupEntity updateTransmitting(RemoteProcessGroupEntity entity, boolean transmitting) throws NiFiClientException, IOException {
        RemoteProcessGroupDTO component = new RemoteProcessGroupDTO();
        component.setId(entity.getComponent().getId());
        component.setParentGroupId(entity.getComponent().getParentGroupId());
        component.setTransmitting(Boolean.valueOf(transmitting));
        RemoteProcessGroupEntity transmittingEntity = new RemoteProcessGroupEntity();
        transmittingEntity.setId(entity.getId());
        transmittingEntity.setRevision(entity.getRevision());
        transmittingEntity.setComponent(component);
        return this.updateRemoteProcessGroup(transmittingEntity);
    }
}

