/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client.nifi.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ParamContextClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.AbstractJerseyClient;
import org.apache.nifi.web.api.entity.ParameterContextEntity;
import org.apache.nifi.web.api.entity.ParameterContextUpdateRequestEntity;
import org.apache.nifi.web.api.entity.ParameterContextsEntity;

public class JerseyParamContextClient
extends AbstractJerseyClient
implements ParamContextClient {
    private final WebTarget flowTarget;
    private final WebTarget paramContextTarget;

    public JerseyParamContextClient(WebTarget baseTarget) {
        this(baseTarget, Collections.emptyMap());
    }

    public JerseyParamContextClient(WebTarget baseTarget, Map<String, String> headers) {
        super(headers);
        this.flowTarget = baseTarget.path("/flow");
        this.paramContextTarget = baseTarget.path("/parameter-contexts");
    }

    @Override
    public ParameterContextsEntity getParamContexts() throws NiFiClientException, IOException {
        return this.executeAction("Error retrieving parameter contexts", () -> {
            WebTarget target = this.flowTarget.path("/parameter-contexts");
            return (ParameterContextsEntity)this.getRequestBuilder(target).get(ParameterContextsEntity.class);
        });
    }

    @Override
    public ParameterContextEntity getParamContext(String id) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Parameter context id cannot be null or blank");
        }
        return this.executeAction("Error retrieving parameter context", () -> {
            WebTarget target = this.paramContextTarget.path("{id}").resolveTemplate("id", (Object)id);
            return (ParameterContextEntity)this.getRequestBuilder(target).get(ParameterContextEntity.class);
        });
    }

    @Override
    public ParameterContextEntity createParamContext(ParameterContextEntity paramContext) throws NiFiClientException, IOException {
        if (paramContext == null) {
            throw new IllegalArgumentException("Parameter context cannot be null or blank");
        }
        return this.executeAction("Error creating parameter context", () -> {
            WebTarget target = this.paramContextTarget;
            return (ParameterContextEntity)this.getRequestBuilder(target).post(Entity.entity((Object)paramContext, (String)"application/json"), ParameterContextEntity.class);
        });
    }

    @Override
    public ParameterContextEntity deleteParamContext(String id, String version) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Parameter context id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IllegalArgumentException("Version cannot be null or blank");
        }
        return this.executeAction("Error deleting parameter context", () -> {
            WebTarget target = this.paramContextTarget.path("{id}").resolveTemplate("id", (Object)id).queryParam("version", new Object[]{version});
            return (ParameterContextEntity)this.getRequestBuilder(target).delete(ParameterContextEntity.class);
        });
    }

    @Override
    public ParameterContextUpdateRequestEntity updateParamContext(ParameterContextEntity paramContext) throws NiFiClientException, IOException {
        if (paramContext == null) {
            throw new IllegalArgumentException("Parameter context entity cannot be null");
        }
        if (paramContext.getComponent() == null) {
            throw new IllegalArgumentException("Parameter context DTO cannot be null");
        }
        String paramContextId = paramContext.getComponent().getId();
        if (StringUtils.isBlank((CharSequence)paramContextId)) {
            throw new IllegalArgumentException("Parameter context id cannot be null or blank");
        }
        return this.executeAction("Error creating parameter context update request", () -> {
            WebTarget target = this.paramContextTarget.path("{id}/update-requests").resolveTemplate("id", (Object)paramContextId);
            return (ParameterContextUpdateRequestEntity)this.getRequestBuilder(target).post(Entity.entity((Object)paramContext, (String)"application/json"), ParameterContextUpdateRequestEntity.class);
        });
    }

    @Override
    public ParameterContextUpdateRequestEntity getParamContextUpdateRequest(String contextId, String updateRequestId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)updateRequestId)) {
            throw new IllegalArgumentException("Parameter context update request id cannot be null or blank");
        }
        return this.executeAction("Error retrieving parameter context", () -> {
            WebTarget target = this.paramContextTarget.path("{context-id}/update-requests/{request-id}").resolveTemplate("context-id", (Object)contextId).resolveTemplate("request-id", (Object)updateRequestId);
            return (ParameterContextUpdateRequestEntity)this.getRequestBuilder(target).get(ParameterContextUpdateRequestEntity.class);
        });
    }

    @Override
    public ParameterContextUpdateRequestEntity deleteParamContextUpdateRequest(String contextId, String updateRequestId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)updateRequestId)) {
            throw new IllegalArgumentException("Parameter context update request id cannot be null or blank");
        }
        return this.executeAction("Error deleting parameter context update request", () -> {
            WebTarget target = this.paramContextTarget.path("{context-id}/update-requests/{request-id}").resolveTemplate("context-id", (Object)contextId).resolveTemplate("request-id", (Object)updateRequestId);
            return (ParameterContextUpdateRequestEntity)this.getRequestBuilder(target).delete(ParameterContextUpdateRequestEntity.class);
        });
    }
}

