/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client.nifi.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;

public class AbstractJerseyClient {
    private final Map<String, String> headers;

    public AbstractJerseyClient(Map<String, String> headers) {
        this.headers = headers == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, String>(headers));
    }

    protected Map<String, String> getHeaders() {
        return this.headers;
    }

    protected Invocation.Builder getRequestBuilder(WebTarget webTarget) {
        Invocation.Builder requestBuilder = webTarget.request();
        this.headers.entrySet().stream().forEach(e -> requestBuilder.header((String)e.getKey(), e.getValue()));
        return requestBuilder;
    }

    protected <T> T executeAction(String errorMessage, NiFiAction<T> action) throws NiFiClientException, IOException {
        try {
            return action.execute();
        }
        catch (Exception e) {
            Throwable ioeCause = this.getIOExceptionCause(e);
            if (ioeCause == null) {
                StringBuilder errorMessageBuilder = new StringBuilder(errorMessage);
                if (e instanceof WebApplicationException) {
                    Response response = ((WebApplicationException)e).getResponse();
                    String responseBody = (String)response.readEntity(String.class);
                    errorMessageBuilder.append(": ").append(responseBody);
                }
                throw new NiFiClientException(errorMessageBuilder.toString(), e);
            }
            throw (IOException)ioeCause;
        }
    }

    protected Throwable getIOExceptionCause(Throwable e) {
        if (e == null) {
            return null;
        }
        if (e instanceof IOException) {
            return e;
        }
        return this.getIOExceptionCause(e.getCause());
    }

    protected static interface NiFiAction<T> {
        public T execute();
    }
}

