/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.client.BucketClient;
import org.apache.nifi.registry.client.BundleClient;
import org.apache.nifi.registry.client.BundleVersionClient;
import org.apache.nifi.registry.client.ExtensionClient;
import org.apache.nifi.registry.client.ExtensionRepoClient;
import org.apache.nifi.registry.client.FlowClient;
import org.apache.nifi.registry.client.FlowSnapshotClient;
import org.apache.nifi.registry.client.ItemsClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryClientConfig;
import org.apache.nifi.registry.client.UserClient;
import org.apache.nifi.registry.client.impl.JerseyNiFiRegistryClient;
import org.apache.nifi.registry.security.util.KeystoreType;
import org.apache.nifi.toolkit.cli.api.ClientFactory;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;

public class NiFiRegistryClientFactory
implements ClientFactory<NiFiRegistryClient> {
    @Override
    public NiFiRegistryClient createClient(Properties properties) throws MissingOptionException {
        String url = properties.getProperty(CommandOption.URL.getLongName());
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new MissingOptionException("Missing required option '" + CommandOption.URL.getLongName() + "'");
        }
        String keystore = properties.getProperty(CommandOption.KEYSTORE.getLongName());
        String keystoreType = properties.getProperty(CommandOption.KEYSTORE_TYPE.getLongName());
        String keystorePasswd = properties.getProperty(CommandOption.KEYSTORE_PASSWORD.getLongName());
        String keyPasswd = properties.getProperty(CommandOption.KEY_PASSWORD.getLongName());
        String truststore = properties.getProperty(CommandOption.TRUSTSTORE.getLongName());
        String truststoreType = properties.getProperty(CommandOption.TRUSTSTORE_TYPE.getLongName());
        String truststorePasswd = properties.getProperty(CommandOption.TRUSTSTORE_PASSWORD.getLongName());
        String proxiedEntity = properties.getProperty(CommandOption.PROXIED_ENTITY.getLongName());
        boolean secureUrl = url.startsWith("https");
        if (secureUrl && (StringUtils.isBlank((CharSequence)truststore) || StringUtils.isBlank((CharSequence)truststoreType) || StringUtils.isBlank((CharSequence)truststorePasswd))) {
            throw new MissingOptionException(CommandOption.TRUSTSTORE.getLongName() + ", " + CommandOption.TRUSTSTORE_TYPE.getLongName() + ", and " + CommandOption.TRUSTSTORE_PASSWORD.getLongName() + " are required when using an https url");
        }
        NiFiRegistryClientConfig.Builder clientConfigBuilder = new NiFiRegistryClientConfig.Builder().baseUrl(url);
        if (secureUrl) {
            if (!StringUtils.isBlank((CharSequence)keystore)) {
                clientConfigBuilder.keystoreFilename(keystore);
            }
            if (!StringUtils.isBlank((CharSequence)keystoreType)) {
                clientConfigBuilder.keystoreType(KeystoreType.valueOf((String)keystoreType.toUpperCase()));
            }
            if (!StringUtils.isBlank((CharSequence)keystorePasswd)) {
                clientConfigBuilder.keystorePassword(keystorePasswd);
            }
            if (!StringUtils.isBlank((CharSequence)keyPasswd)) {
                clientConfigBuilder.keyPassword(keyPasswd);
            }
            if (!StringUtils.isBlank((CharSequence)truststore)) {
                clientConfigBuilder.truststoreFilename(truststore);
            }
            if (!StringUtils.isBlank((CharSequence)truststoreType)) {
                clientConfigBuilder.truststoreType(KeystoreType.valueOf((String)truststoreType.toUpperCase()));
            }
            if (!StringUtils.isBlank((CharSequence)truststorePasswd)) {
                clientConfigBuilder.truststorePassword(truststorePasswd);
            }
        }
        NiFiRegistryClient client = new JerseyNiFiRegistryClient.Builder().config(clientConfigBuilder.build()).build();
        if (!StringUtils.isBlank((CharSequence)proxiedEntity)) {
            return new ProxiedNiFiRegistryClient(client, proxiedEntity);
        }
        return client;
    }

    private static class ProxiedNiFiRegistryClient
    implements NiFiRegistryClient {
        private final NiFiRegistryClient client;
        private final String proxiedEntity;

        public ProxiedNiFiRegistryClient(NiFiRegistryClient client, String proxiedEntity) {
            this.client = client;
            this.proxiedEntity = proxiedEntity;
        }

        public BucketClient getBucketClient() {
            return this.getBucketClient(this.proxiedEntity);
        }

        public BucketClient getBucketClient(String ... proxiedEntity) {
            return this.client.getBucketClient(proxiedEntity);
        }

        public FlowClient getFlowClient() {
            return this.getFlowClient(this.proxiedEntity);
        }

        public FlowClient getFlowClient(String ... proxiedEntity) {
            return this.client.getFlowClient(proxiedEntity);
        }

        public FlowSnapshotClient getFlowSnapshotClient() {
            return this.getFlowSnapshotClient(this.proxiedEntity);
        }

        public FlowSnapshotClient getFlowSnapshotClient(String ... proxiedEntity) {
            return this.client.getFlowSnapshotClient(proxiedEntity);
        }

        public ItemsClient getItemsClient() {
            return this.getItemsClient(this.proxiedEntity);
        }

        public ItemsClient getItemsClient(String ... proxiedEntity) {
            return this.client.getItemsClient(proxiedEntity);
        }

        public UserClient getUserClient() {
            return this.getUserClient(this.proxiedEntity);
        }

        public UserClient getUserClient(String ... proxiedEntity) {
            return this.client.getUserClient(proxiedEntity);
        }

        public BundleClient getBundleClient() {
            return this.getBundleClient(this.proxiedEntity);
        }

        public BundleClient getBundleClient(String ... proxiedEntity) {
            return this.client.getBundleClient(proxiedEntity);
        }

        public BundleVersionClient getBundleVersionClient() {
            return this.getBundleVersionClient(this.proxiedEntity);
        }

        public BundleVersionClient getBundleVersionClient(String ... proxiedEntity) {
            return this.client.getBundleVersionClient(proxiedEntity);
        }

        public ExtensionRepoClient getExtensionRepoClient() {
            return this.getExtensionRepoClient(this.proxiedEntity);
        }

        public ExtensionRepoClient getExtensionRepoClient(String ... proxiedEntity) {
            return this.client.getExtensionRepoClient(proxiedEntity);
        }

        public ExtensionClient getExtensionClient() {
            return this.getExtensionClient(this.proxiedEntity);
        }

        public ExtensionClient getExtensionClient(String ... proxiedEntity) {
            return this.client.getExtensionClient(proxiedEntity);
        }

        public void close() throws IOException {
            this.client.close();
        }
    }
}

