/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;

public class ControllerServiceResult
extends AbstractWritableResult<ControllerServiceEntity> {
    private final ControllerServiceEntity controllerServiceEntity;

    public ControllerServiceResult(ResultType resultType, ControllerServiceEntity controllerServiceEntity) {
        super(resultType);
        this.controllerServiceEntity = controllerServiceEntity;
        Validate.notNull((Object)controllerServiceEntity);
    }

    @Override
    public ControllerServiceEntity getResult() {
        return this.controllerServiceEntity;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        ControllerServiceDTO controllerServiceDTO = this.controllerServiceEntity.getComponent();
        BundleDTO bundle = controllerServiceDTO.getBundle();
        output.printf("Name  : %s\nID    : %s\nType  : %s\nBundle: %s - %s %s\nState : %s\n", controllerServiceDTO.getName(), controllerServiceDTO.getId(), controllerServiceDTO.getType(), bundle.getGroup(), bundle.getArtifact(), bundle.getVersion(), controllerServiceDTO.getState());
    }
}

