/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.registry;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ControllerClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.web.api.entity.RegistryClientEntity;

public class UpdateRegistryClient
extends AbstractNiFiCommand<VoidResult> {
    public UpdateRegistryClient() {
        super("update-reg-client", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Updates the given registry client with a new name, url, or description.";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.REGISTRY_CLIENT_ID.createOption());
        this.addOption(CommandOption.REGISTRY_CLIENT_NAME.createOption());
        this.addOption(CommandOption.REGISTRY_CLIENT_URL.createOption());
        this.addOption(CommandOption.REGISTRY_CLIENT_DESC.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String id;
        ControllerClient controllerClient = client.getControllerClient();
        RegistryClientEntity existingRegClient = controllerClient.getRegistryClient(id = this.getRequiredArg(properties, CommandOption.REGISTRY_CLIENT_ID));
        if (existingRegClient == null) {
            throw new CommandException("Registry client does not exist for id " + id);
        }
        String name = this.getArg(properties, CommandOption.REGISTRY_CLIENT_NAME);
        String url = this.getArg(properties, CommandOption.REGISTRY_CLIENT_URL);
        String desc = this.getArg(properties, CommandOption.REGISTRY_CLIENT_DESC);
        if (StringUtils.isBlank((CharSequence)name) && StringUtils.isBlank((CharSequence)url) && StringUtils.isBlank((CharSequence)desc)) {
            throw new CommandException("Name, url, and desc were all blank, nothing to update");
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            existingRegClient.getComponent().setName(name);
        }
        if (StringUtils.isNotBlank((CharSequence)url)) {
            existingRegClient.getComponent().setUri(url);
        }
        if (StringUtils.isNotBlank((CharSequence)desc)) {
            existingRegClient.getComponent().setDescription(desc);
        }
        String clientId = this.getContext().getSession().getNiFiClientID();
        existingRegClient.getRevision().setClientId(clientId);
        controllerClient.updateRegistryClient(existingRegClient);
        return VoidResult.getInstance();
    }
}

