/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client.nifi;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.nifi.registry.security.util.KeyStoreUtils;
import org.apache.nifi.registry.security.util.KeystoreType;

public class NiFiClientConfig {
    public static final String DEFAULT_PROTOCOL = "TLSv1.2";
    private final String baseUrl;
    private final SSLContext sslContext;
    private final String keystoreFilename;
    private final String keystorePass;
    private final String keyPass;
    private final KeystoreType keystoreType;
    private final String truststoreFilename;
    private final String truststorePass;
    private final KeystoreType truststoreType;
    private final String protocol;
    private final HostnameVerifier hostnameVerifier;
    private final Integer readTimeout;
    private final Integer connectTimeout;

    private NiFiClientConfig(Builder builder) {
        this.baseUrl = builder.baseUrl;
        this.sslContext = builder.sslContext;
        this.keystoreFilename = builder.keystoreFilename;
        this.keystorePass = builder.keystorePass;
        this.keyPass = builder.keyPass;
        this.keystoreType = builder.keystoreType;
        this.truststoreFilename = builder.truststoreFilename;
        this.truststorePass = builder.truststorePass;
        this.truststoreType = builder.truststoreType;
        this.protocol = builder.protocol == null ? DEFAULT_PROTOCOL : builder.protocol;
        this.hostnameVerifier = builder.hostnameVerifier;
        this.readTimeout = builder.readTimeout;
        this.connectTimeout = builder.connectTimeout;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public SSLContext getSslContext() {
        TrustManagerFactory trustManagerFactory;
        KeyManagerFactory keyManagerFactory;
        if (this.sslContext != null) {
            return this.sslContext;
        }
        if (this.keystoreFilename != null && this.keystorePass != null && this.keystoreType != null) {
            try {
                KeyStore keyStore = KeyStoreUtils.getKeyStore((String)this.keystoreType.name());
                try (FileInputStream keyStoreStream = new FileInputStream(new File(this.keystoreFilename));){
                    keyStore.load(keyStoreStream, this.keystorePass.toCharArray());
                }
                keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                if (this.keyPass == null) {
                    keyManagerFactory.init(keyStore, this.keystorePass.toCharArray());
                }
                keyManagerFactory.init(keyStore, this.keyPass.toCharArray());
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to load Keystore", e);
            }
        } else {
            keyManagerFactory = null;
        }
        if (this.truststoreFilename != null && this.truststorePass != null && this.truststoreType != null) {
            try {
                KeyStore trustStore = KeyStoreUtils.getTrustStore((String)this.truststoreType.name());
                try (FileInputStream trustStoreStream = new FileInputStream(new File(this.truststoreFilename));){
                    trustStore.load(trustStoreStream, this.truststorePass.toCharArray());
                }
                trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(trustStore);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to load Truststore", e);
            }
        }
        trustManagerFactory = null;
        if (keyManagerFactory != null || trustManagerFactory != null) {
            try {
                KeyManager[] keyManagers = keyManagerFactory != null ? keyManagerFactory.getKeyManagers() : null;
                TrustManager[] trustManagers = trustManagerFactory != null ? trustManagerFactory.getTrustManagers() : null;
                SSLContext sslContext = SSLContext.getInstance(this.getProtocol());
                sslContext.init(keyManagers, trustManagers, new SecureRandom());
                sslContext.getDefaultSSLParameters().setNeedClientAuth(true);
                return sslContext;
            }
            catch (Exception e) {
                throw new IllegalStateException("Created keystore and truststore but failed to initialize SSLContext", e);
            }
        }
        return null;
    }

    public String getKeystoreFilename() {
        return this.keystoreFilename;
    }

    public String getKeystorePass() {
        return this.keystorePass;
    }

    public String getKeyPass() {
        return this.keyPass;
    }

    public KeystoreType getKeystoreType() {
        return this.keystoreType;
    }

    public String getTruststoreFilename() {
        return this.truststoreFilename;
    }

    public String getTruststorePass() {
        return this.truststorePass;
    }

    public KeystoreType getTruststoreType() {
        return this.truststoreType;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public static class Builder {
        private String baseUrl;
        private SSLContext sslContext;
        private String keystoreFilename;
        private String keystorePass;
        private String keyPass;
        private KeystoreType keystoreType;
        private String truststoreFilename;
        private String truststorePass;
        private KeystoreType truststoreType;
        private String protocol;
        private HostnameVerifier hostnameVerifier;
        private Integer readTimeout;
        private Integer connectTimeout;

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder keystoreFilename(String keystoreFilename) {
            this.keystoreFilename = keystoreFilename;
            return this;
        }

        public Builder keystorePassword(String keystorePass) {
            this.keystorePass = keystorePass;
            return this;
        }

        public Builder keyPassword(String keyPass) {
            this.keyPass = keyPass;
            return this;
        }

        public Builder keystoreType(KeystoreType keystoreType) {
            this.keystoreType = keystoreType;
            return this;
        }

        public Builder truststoreFilename(String truststoreFilename) {
            this.truststoreFilename = truststoreFilename;
            return this;
        }

        public Builder truststorePassword(String truststorePass) {
            this.truststorePass = truststorePass;
            return this;
        }

        public Builder truststoreType(KeystoreType truststoreType) {
            this.truststoreType = truststoreType;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder readTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder connectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public NiFiClientConfig build() {
            return new NiFiClientConfig(this);
        }
    }
}

