/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.cs.tests.system.SleepService;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

public class Sleep
extends AbstractProcessor {
    public static final PropertyDescriptor VALIDATE_SLEEP_TIME = new PropertyDescriptor.Builder().name("Validate Sleep Time").description("The amount of time to sleep during validation").required(false).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("0 sec").build();
    public static final PropertyDescriptor ON_TRIGGER_SLEEP_TIME = new PropertyDescriptor.Builder().name("onTrigger Sleep Time").description("The amount of time to sleep during each trigger").required(false).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("0 sec").build();
    public static final PropertyDescriptor ON_SCHEDULED_SLEEP_TIME = new PropertyDescriptor.Builder().name("@OnScheduled Sleep Time").description("The amount of time to sleep when scheduled").required(false).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("0 sec").build();
    public static final PropertyDescriptor ON_STOPPED_SLEEP_TIME = new PropertyDescriptor.Builder().name("@OnStopped Sleep Time").description("The amount of time to sleep when stopped").required(false).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("0 sec").build();
    static final PropertyDescriptor SLEEP_SERVICE = new PropertyDescriptor.Builder().name("Sleep Service").description("Controller Service that sleeps").required(false).identifiesControllerService(SleepService.class).build();
    static final PropertyDescriptor IGNORE_INTERRUPTS = new PropertyDescriptor.Builder().name("Ignore Interrupts").description("If true, the processor will not respond to interrupts while sleeping.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    static final PropertyDescriptor STOP_SLEEPING_WHEN_UNSCHEDULED = new PropertyDescriptor.Builder().name("Stop Sleeping When Unscheduled").description("If true, the processor will stop sleeping whenever the processor is unscheduled. If false, the processor will continue sleeping until the sleep time has elapsed. This property only applies to the onTrigger Sleep Time.").required(false).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    private static final List<PropertyDescriptor> properties = List.of(VALIDATE_SLEEP_TIME, ON_SCHEDULED_SLEEP_TIME, ON_TRIGGER_SLEEP_TIME, ON_STOPPED_SLEEP_TIME, SLEEP_SERVICE, IGNORE_INTERRUPTS, STOP_SLEEPING_WHEN_UNSCHEDULED);
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    public Set<Relationship> getRelationships() {
        return Set.of(REL_SUCCESS);
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        long sleepMillis = validationContext.getProperty(VALIDATE_SLEEP_TIME).asTimePeriod(TimeUnit.MILLISECONDS);
        this.sleep(sleepMillis, this.isIgnoreInterrupt((PropertyContext)validationContext), false);
        return Collections.emptyList();
    }

    private void sleep(long millis, boolean ignoreInterrupts, boolean stopSleepOnUnscheduled) {
        if (millis == 0L) {
            return;
        }
        long stopTime = System.currentTimeMillis() + millis;
        while (System.currentTimeMillis() < stopTime) {
            if (stopSleepOnUnscheduled && !this.isScheduled()) {
                return;
            }
            long sleepMillis = Math.min(stopTime - System.currentTimeMillis(), 50L);
            try {
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException e) {
                if (ignoreInterrupts) continue;
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    @OnScheduled
    public void onEnabled(ProcessContext context) {
        this.sleep(context.getProperty(ON_SCHEDULED_SLEEP_TIME).asTimePeriod(TimeUnit.MILLISECONDS), this.isIgnoreInterrupt((PropertyContext)context), false);
    }

    private boolean isIgnoreInterrupt(PropertyContext context) {
        return context.getProperty(IGNORE_INTERRUPTS).asBoolean();
    }

    @OnStopped
    public void onDisabled(ProcessContext context) {
        this.sleep(context.getProperty(ON_STOPPED_SLEEP_TIME).asTimePeriod(TimeUnit.MILLISECONDS), this.isIgnoreInterrupt((PropertyContext)context), false);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        long sleepMillis = context.getProperty(ON_TRIGGER_SLEEP_TIME).asTimePeriod(TimeUnit.MILLISECONDS);
        boolean ignoreInterrupts = this.isIgnoreInterrupt((PropertyContext)context);
        boolean stopSleepOnUnscheduled = context.getProperty(STOP_SLEEPING_WHEN_UNSCHEDULED).asBoolean();
        this.sleep(sleepMillis, ignoreInterrupts, stopSleepOnUnscheduled);
        SleepService service = (SleepService)context.getProperty(SLEEP_SERVICE).asControllerService(SleepService.class);
        if (service != null) {
            service.sleep();
        }
        this.getLogger().info("Finished onTrigger sleep");
        session.transfer(flowFile, REL_SUCCESS);
    }
}

