/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.stream.io.StreamUtils;

@SupportsBatching
public class ReverseContents
extends AbstractProcessor {
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").build();

    public Set<Relationship> getRelationships() {
        return Collections.singleton(REL_SUCCESS);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        byte[] buffer = new byte[(int)flowFile.getSize()];
        try (InputStream in = session.read(flowFile);){
            StreamUtils.fillBuffer((InputStream)in, (byte[])buffer);
        }
        catch (IOException e) {
            throw new ProcessException((Throwable)e);
        }
        try (OutputStream out = session.write(flowFile);){
            for (int i = buffer.length - 1; i >= 0; --i) {
                out.write(buffer[i]);
            }
        }
        catch (IOException e) {
            throw new ProcessException((Throwable)e);
        }
        session.transfer(flowFile, REL_SUCCESS);
    }
}

