/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

public class PartitionText
extends AbstractProcessor {
    static final PropertyDescriptor OUTPUT_FLOWFILES = new PropertyDescriptor.Builder().name("Number of Output FlowFiles").displayName("Number of Output FlowFiles").description("The number of Output FlowFiles").required(true).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue("2").build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Collections.singletonList(OUTPUT_FLOWFILES);
    }

    public Set<Relationship> getRelationships() {
        return Collections.singleton(REL_SUCCESS);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        int outputCount = context.getProperty(OUTPUT_FLOWFILES).evaluateAttributeExpressions(flowFile).asInteger();
        HashMap<Integer, FlowFile> outputFlowFiles = new HashMap<Integer, FlowFile>();
        HashMap<Integer, OutputStream> outputStreams = new HashMap<Integer, OutputStream>();
        try {
            try (InputStream in = session.read(flowFile);
                 InputStreamReader streamReader = new InputStreamReader(in);
                 BufferedReader reader = new BufferedReader(streamReader);){
                String line;
                long lineCount = 0L;
                while ((line = reader.readLine()) != null) {
                    int flowFileIndex;
                    OutputStream out;
                    if ((out = (OutputStream)outputStreams.get(flowFileIndex = (int)(lineCount++ % (long)outputCount))) == null) {
                        FlowFile outputFlowFile = session.create(flowFile);
                        out = session.write(outputFlowFile);
                        outputFlowFiles.put(flowFileIndex, outputFlowFile);
                        outputStreams.put(flowFileIndex, out);
                    }
                    out.write(line.getBytes());
                    out.write("\n".getBytes());
                }
            }
            outputStreams.values().forEach(this::closeQuietly);
            session.transfer(outputFlowFiles.values(), REL_SUCCESS);
            session.remove(flowFile);
        }
        catch (IOException e) {
            throw new ProcessException((Throwable)e);
        }
    }

    private void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

