/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.engine;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.stateless.engine.ProcessContextFactory;

public class CachingProcessContextFactory
implements ProcessContextFactory {
    private final ProcessContextFactory delegate;
    private final Map<Connectable, ProcessContext> processContexts = new ConcurrentHashMap<Connectable, ProcessContext>();

    public CachingProcessContextFactory(ProcessContextFactory delegate) {
        this.delegate = delegate;
    }

    @Override
    public ProcessContext createProcessContext(Connectable connectable) {
        ProcessContext context = this.processContexts.get(connectable);
        if (context != null) {
            return context;
        }
        ProcessContext created = this.delegate.createProcessContext(connectable);
        this.processContexts.putIfAbsent(connectable, created);
        return created;
    }
}

