/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.flow;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.flow.Bundle;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedControllerService;
import org.apache.nifi.flow.VersionedExternalFlow;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flow.VersionedProcessor;
import org.apache.nifi.stateless.config.ParameterContextDefinition;
import org.apache.nifi.stateless.config.ParameterValueProviderDefinition;
import org.apache.nifi.stateless.config.ReportingTaskDefinition;
import org.apache.nifi.stateless.flow.DataflowDefinition;
import org.apache.nifi.stateless.flow.TransactionThresholds;

public class StandardDataflowDefinition
implements DataflowDefinition {
    private final VersionedExternalFlow versionedExternalFlow;
    private final Set<String> failurePortNames;
    private final List<ParameterContextDefinition> parameterContexts;
    private final List<ReportingTaskDefinition> reportingTaskDefinitions;
    private final List<ParameterValueProviderDefinition> parameterValueProviderDefinitions;
    private final TransactionThresholds transactionThresholds;

    private StandardDataflowDefinition(Builder builder) {
        this.versionedExternalFlow = Objects.requireNonNull(builder.versionedExternalFlow, "Flow Snapshot must be provided");
        this.failurePortNames = builder.failurePortNames == null ? Collections.emptySet() : builder.failurePortNames;
        this.parameterContexts = builder.parameterContexts == null ? Collections.emptyList() : builder.parameterContexts;
        this.reportingTaskDefinitions = builder.reportingTaskDefinitions == null ? Collections.emptyList() : builder.reportingTaskDefinitions;
        this.transactionThresholds = builder.transactionThresholds == null ? TransactionThresholds.SINGLE_FLOWFILE : builder.transactionThresholds;
        this.parameterValueProviderDefinitions = builder.parameterValueProviderDefinitions == null ? Collections.emptyList() : builder.parameterValueProviderDefinitions;
    }

    public VersionedExternalFlow getVersionedExternalFlow() {
        return this.versionedExternalFlow;
    }

    public String getFlowName() {
        return this.versionedExternalFlow.getMetadata().getFlowName();
    }

    public Set<String> getFailurePortNames() {
        return this.failurePortNames;
    }

    public Set<String> getInputPortNames() {
        return this.versionedExternalFlow.getFlowContents().getInputPorts().stream().map(VersionedComponent::getName).collect(Collectors.toSet());
    }

    public Set<String> getOutputPortNames() {
        return this.versionedExternalFlow.getFlowContents().getOutputPorts().stream().map(VersionedComponent::getName).collect(Collectors.toSet());
    }

    public List<ParameterContextDefinition> getParameterContexts() {
        return this.parameterContexts;
    }

    public List<ReportingTaskDefinition> getReportingTaskDefinitions() {
        return this.reportingTaskDefinitions;
    }

    public List<ParameterValueProviderDefinition> getParameterValueProviderDefinitions() {
        return this.parameterValueProviderDefinitions;
    }

    public TransactionThresholds getTransactionThresholds() {
        return this.transactionThresholds;
    }

    public Set<Bundle> getReferencedBundles() {
        HashSet<Bundle> referenced = new HashSet<Bundle>();
        VersionedProcessGroup rootGroup = this.versionedExternalFlow.getFlowContents();
        this.discoverReferencedBundles(rootGroup, referenced);
        return referenced;
    }

    private void discoverReferencedBundles(VersionedProcessGroup group, Set<Bundle> referenced) {
        for (VersionedProcessor processor : group.getProcessors()) {
            referenced.add(processor.getBundle());
        }
        for (VersionedControllerService controllerService : group.getControllerServices()) {
            referenced.add(controllerService.getBundle());
        }
        for (VersionedProcessGroup childGroup : group.getProcessGroups()) {
            this.discoverReferencedBundles(childGroup, referenced);
        }
    }

    public static class Builder {
        private VersionedExternalFlow versionedExternalFlow;
        private Set<String> failurePortNames;
        private List<ParameterContextDefinition> parameterContexts;
        private List<ReportingTaskDefinition> reportingTaskDefinitions;
        private List<ParameterValueProviderDefinition> parameterValueProviderDefinitions;
        private TransactionThresholds transactionThresholds;

        public Builder versionedExternalFlow(VersionedExternalFlow versionedExternalFlow) {
            this.versionedExternalFlow = versionedExternalFlow;
            return this;
        }

        public Builder failurePortNames(Set<String> failurePortNames) {
            this.failurePortNames = failurePortNames;
            return this;
        }

        public Builder parameterContexts(List<ParameterContextDefinition> parameterContexts) {
            this.parameterContexts = parameterContexts;
            return this;
        }

        public Builder reportingTasks(List<ReportingTaskDefinition> reportingTasks) {
            this.reportingTaskDefinitions = reportingTasks;
            return this;
        }

        public Builder parameterValueProviders(List<ParameterValueProviderDefinition> parameterValueProviders) {
            this.parameterValueProviderDefinitions = parameterValueProviders;
            return this;
        }

        public Builder transactionThresholds(TransactionThresholds thresholds) {
            this.transactionThresholds = thresholds;
            return this;
        }

        public StandardDataflowDefinition build() {
            return new StandardDataflowDefinition(this);
        }
    }
}

