/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.parameter;

import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.stateless.parameter.AbstractParameterValueProvider;
import org.apache.nifi.stateless.parameter.ParameterValueProvider;

public class CompositeParameterValueProvider
extends AbstractParameterValueProvider
implements ParameterValueProvider {
    private final List<ParameterValueProvider> parameterValueProviders;

    public CompositeParameterValueProvider(List<ParameterValueProvider> providers) {
        this.parameterValueProviders = new ArrayList<ParameterValueProvider>(providers);
    }

    public String getParameterValue(String contextName, String parameterName) {
        for (ParameterValueProvider provider : this.parameterValueProviders) {
            String value;
            if (!provider.isParameterDefined(contextName, parameterName) || (value = provider.getParameterValue(contextName, parameterName)) == null) continue;
            return value;
        }
        return null;
    }

    public boolean isParameterDefined(String contextName, String parameterName) {
        for (ParameterValueProvider provider : this.parameterValueProviders) {
            boolean defined = provider.isParameterDefined(contextName, parameterName);
            if (!defined) continue;
            return true;
        }
        return false;
    }
}

