/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.engine;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import javax.net.ssl.SSLContext;
import org.apache.nifi.annotation.lifecycle.OnAdded;
import org.apache.nifi.annotation.lifecycle.OnConfigurationRestored;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.LocalPort;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.StandardConnection;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.FlowAnalysisRuleNode;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.controller.ParameterProviderNode;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.StandardFunnel;
import org.apache.nifi.controller.exception.ComponentLifeCycleException;
import org.apache.nifi.controller.exception.ProcessorInstantiationException;
import org.apache.nifi.controller.flow.AbstractFlowManager;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.flowrepository.FlowRepositoryClientInstantiationException;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.label.StandardLabel;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.queue.FlowFileQueueFactory;
import org.apache.nifi.controller.queue.LoadBalanceStrategy;
import org.apache.nifi.controller.reporting.ReportingTaskInstantiationException;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.groups.StandardProcessGroup;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.ControllerServiceLogObserver;
import org.apache.nifi.logging.FlowRegistryClientLogObserver;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogObserver;
import org.apache.nifi.logging.LogRepository;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.apache.nifi.logging.ProcessorLogObserver;
import org.apache.nifi.logging.ReportingTaskLogObserver;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.parameter.ParameterContextManager;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.StandardProcessContext;
import org.apache.nifi.registry.flow.FlowRegistryClientNode;
import org.apache.nifi.remote.StandardRemoteProcessGroup;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.stateless.engine.ComponentBuilder;
import org.apache.nifi.stateless.engine.StatelessEngine;
import org.apache.nifi.stateless.engine.StatelessNodeTypeProvider;
import org.apache.nifi.stateless.queue.StatelessFlowFileQueue;
import org.apache.nifi.util.ReflectionUtils;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatelessFlowManager
extends AbstractFlowManager
implements FlowManager {
    private static final Logger logger = LoggerFactory.getLogger(StatelessFlowManager.class);
    private final StatelessEngine statelessEngine;
    private final SSLContext sslContext;
    private final BulletinRepository bulletinRepository;

    public StatelessFlowManager(FlowFileEventRepository flowFileEventRepository, ParameterContextManager parameterContextManager, StatelessEngine statelessEngine, BooleanSupplier flowInitializedCheck, SSLContext sslContext, BulletinRepository bulletinRepository) {
        super(flowFileEventRepository, parameterContextManager, flowInitializedCheck);
        this.statelessEngine = statelessEngine;
        this.sslContext = sslContext;
        this.bulletinRepository = bulletinRepository;
    }

    public Port createPublicInputPort(String id, String name) {
        throw new UnsupportedOperationException("Cannot create Public Input Port with name '" + name + "' because Public Input Ports and Public Output Ports are not supported in Stateless NiFi");
    }

    public Port createPublicOutputPort(String id, String name) {
        throw new UnsupportedOperationException("Cannot create Public Output Port with name '" + name + "' because Public Input Ports and Public Output Ports are not supported in Stateless NiFi");
    }

    public Set<Port> getPublicInputPorts() {
        return Collections.emptySet();
    }

    public Set<Port> getPublicOutputPorts() {
        return Collections.emptySet();
    }

    public Optional<Port> getPublicInputPort(String name) {
        return Optional.empty();
    }

    public Optional<Port> getPublicOutputPort(String name) {
        return Optional.empty();
    }

    public RemoteProcessGroup createRemoteProcessGroup(String id, String uris) {
        return new StandardRemoteProcessGroup(id, uris, null, this.statelessEngine.getProcessScheduler(), this.statelessEngine.getBulletinRepository(), this.sslContext, this.statelessEngine.getStateManagerProvider().getStateManager(id), TimeUnit.SECONDS.toMillis(30L));
    }

    public void instantiateSnippet(ProcessGroup group, FlowSnippetDTO dto) {
        throw new UnsupportedOperationException("Flow Snippets are not supported in Stateless NiFi");
    }

    public FlowFilePrioritizer createPrioritizer(String type) {
        return (o1, o2) -> o1.getLastQueueDate().compareTo(o2.getLastQueueDate());
    }

    public ProcessorNode createProcessor(String type, String id, BundleCoordinate coordinate, Set<URL> additionalUrls, boolean firstTimeAdded, boolean registerLogObserver, String classloaderIsolationKey) {
        logger.debug("Creating Processor of type {} with id {}", (Object)type, (Object)id);
        LogRepository logRepository = LogRepositoryFactory.getRepository((String)id);
        ExtensionManager extensionManager = this.statelessEngine.getExtensionManager();
        try {
            NarCloseable ignored;
            ProcessorNode procNode = new ComponentBuilder().identifier(id).type(type).bundleCoordinate(coordinate).statelessEngine(this.statelessEngine).additionalClassPathUrls(additionalUrls).buildProcessor();
            try {
                ignored = NarCloseable.withComponentNarLoader((ExtensionManager)extensionManager, (Class)procNode.getProcessor().getClass(), (String)procNode.getProcessor().getIdentifier());
                try {
                    ReflectionUtils.invokeMethodsWithAnnotation(OnAdded.class, (Object)procNode.getProcessor(), (Object[])new Object[0]);
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
            }
            catch (Exception e) {
                throw new ComponentLifeCycleException("Failed to invoke @OnAdded methods of " + String.valueOf(procNode.getProcessor()), (Throwable)e);
            }
            ignored = NarCloseable.withComponentNarLoader((ExtensionManager)extensionManager, (Class)procNode.getProcessor().getClass(), (String)procNode.getProcessor().getIdentifier());
            try {
                StateManager stateManager = this.statelessEngine.getStateManagerProvider().getStateManager(id);
                StandardProcessContext processContext = new StandardProcessContext(procNode, this.statelessEngine.getControllerServiceProvider(), stateManager, () -> false, (NodeTypeProvider)new StatelessNodeTypeProvider());
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnConfigurationRestored.class, (Object)procNode.getProcessor(), (Object[])new Object[]{processContext});
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
            LogRepositoryFactory.getRepository((String)procNode.getIdentifier()).setLogger((ComponentLog)procNode.getLogger());
            if (registerLogObserver && !logRepository.hasObserver()) {
                logRepository.addObserver(procNode.getBulletinLevel(), (LogObserver)new ProcessorLogObserver(this.bulletinRepository, procNode));
            }
            logger.debug("Processor with id {} successfully created", (Object)id);
            return procNode;
        }
        catch (ProcessorInstantiationException e) {
            throw new IllegalStateException("Could not create Processor of type " + type, e);
        }
    }

    public Label createLabel(String id, String text) {
        return new StandardLabel(id, text);
    }

    public Funnel createFunnel(String id) {
        return new StandardFunnel(id, 1, 50000);
    }

    public Port createLocalInputPort(String id, String name) {
        return new LocalPort(id, name, ConnectableType.INPUT_PORT, this.statelessEngine.getProcessScheduler(), 1, 50000, "10 millis");
    }

    public Port createLocalOutputPort(String id, String name) {
        return new LocalPort(id, name, ConnectableType.OUTPUT_PORT, this.statelessEngine.getProcessScheduler(), 1, 50000, "10 millis");
    }

    public ProcessGroup createProcessGroup(String id) {
        StandardProcessGroup created = new StandardProcessGroup(id, this.statelessEngine.getControllerServiceProvider(), this.statelessEngine.getProcessScheduler(), this.statelessEngine.getPropertyEncryptor(), this.statelessEngine.getExtensionManager(), this.statelessEngine.getStateManagerProvider(), (FlowManager)this, this.statelessEngine.getReloadComponent(), (NodeTypeProvider)new StatelessNodeTypeProvider(), null, group -> null, this.statelessEngine.getAssetManager());
        this.onProcessGroupAdded((ProcessGroup)created);
        return created;
    }

    public Connection createConnection(final String id, String name, Connectable source, Connectable destination, Collection<String> relationshipNames) {
        StandardConnection.Builder builder = new StandardConnection.Builder(this.statelessEngine.getProcessScheduler());
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        for (String relationshipName : Objects.requireNonNull(relationshipNames)) {
            relationships.add(new Relationship.Builder().name(relationshipName).build());
        }
        FlowFileQueueFactory flowFileQueueFactory = new FlowFileQueueFactory(){

            public FlowFileQueue createFlowFileQueue(LoadBalanceStrategy loadBalanceStrategy, String partitioningAttribute, ProcessGroup processGroup) {
                return new StatelessFlowFileQueue(id);
            }
        };
        StandardConnection connection = builder.id(Objects.requireNonNull(id).intern()).name(name == null ? null : name.intern()).relationships(relationships).source(Objects.requireNonNull(source)).destination(destination).flowFileQueueFactory(flowFileQueueFactory).processGroup(destination.getProcessGroup()).build();
        return connection;
    }

    public ReportingTaskNode createReportingTask(String type, String id, BundleCoordinate bundleCoordinate, Set<URL> additionalUrls, boolean firstTimeAdded, boolean register, String classloaderIsolationKey) {
        ReportingTaskNode taskNode;
        if (type == null || id == null || bundleCoordinate == null) {
            throw new NullPointerException("Must supply type, id, and bundle coordinate in order to create Reporting Task. Provided arguments were type=" + type + ", id=" + id + ", bundle coordinate = " + String.valueOf(bundleCoordinate));
        }
        LogRepository logRepository = LogRepositoryFactory.getRepository((String)id);
        try {
            taskNode = new ComponentBuilder().identifier(id).type(type).bundleCoordinate(bundleCoordinate).statelessEngine(this.statelessEngine).additionalClassPathUrls(additionalUrls).flowManager(this).buildReportingTask();
        }
        catch (ReportingTaskInstantiationException e) {
            throw new IllegalStateException("Could not create Reporting Task of type " + type + " with ID " + id, e);
        }
        LogRepositoryFactory.getRepository((String)taskNode.getIdentifier()).setLogger((ComponentLog)taskNode.getLogger());
        if (firstTimeAdded) {
            Class taskClass = taskNode.getReportingTask().getClass();
            String identifier = taskNode.getReportingTask().getIdentifier();
            try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ExtensionManager)this.statelessEngine.getExtensionManager(), (Class)taskClass, (String)identifier);){
                ReflectionUtils.invokeMethodsWithAnnotation(OnAdded.class, (Object)taskNode.getReportingTask(), (Object[])new Object[0]);
                if (this.isFlowInitialized()) {
                    ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnConfigurationRestored.class, (Object)taskNode.getReportingTask(), (Object[])new Object[]{taskNode.getConfigurationContext()});
                }
            }
            catch (Exception e) {
                throw new ComponentLifeCycleException("Failed to invoke On-Added Lifecycle methods of " + String.valueOf(taskNode.getReportingTask()), (Throwable)e);
            }
        }
        if (register) {
            this.onReportingTaskAdded(taskNode);
            logRepository.addObserver(LogLevel.WARN, (LogObserver)new ReportingTaskLogObserver(this.bulletinRepository, taskNode));
        }
        return taskNode;
    }

    public ParameterProviderNode createParameterProvider(String type, String id, BundleCoordinate bundleCoordinate, Set<URL> additionalUrls, boolean firstTimeAdded, boolean register) {
        throw new UnsupportedOperationException("Parameter Providers are not supported in Stateless NiFi");
    }

    public FlowRegistryClientNode createFlowRegistryClient(String type, String id, BundleCoordinate bundleCoordinate, Set<URL> additionalUrls, boolean firstTimeAdded, boolean registerLogObserver, String classloaderIsolationKey) {
        FlowRegistryClientNode clientNode;
        LogRepository logRepository = LogRepositoryFactory.getRepository((String)id);
        try {
            clientNode = new ComponentBuilder().identifier(id).type(type).statelessEngine(this.statelessEngine).additionalClassPathUrls(additionalUrls).flowManager(this).buildFlowRegistryClient();
        }
        catch (FlowRepositoryClientInstantiationException e) {
            throw new IllegalStateException("Could not create Flow Registry Client of type " + type + " with ID " + id, e);
        }
        this.onFlowRegistryClientAdded(clientNode);
        LogRepositoryFactory.getRepository((String)clientNode.getIdentifier()).setLogger((ComponentLog)clientNode.getLogger());
        if (registerLogObserver) {
            logRepository.addObserver(LogLevel.WARN, (LogObserver)new FlowRegistryClientLogObserver(this.bulletinRepository, clientNode));
        }
        return clientNode;
    }

    public void removeFlowRegistryClient(FlowRegistryClientNode clientNode) {
        throw new UnsupportedOperationException("Removing Flow Registry Client is not supported in Stateless NiFi");
    }

    protected ExtensionManager getExtensionManager() {
        return this.statelessEngine.getExtensionManager();
    }

    protected ProcessScheduler getProcessScheduler() {
        return this.statelessEngine.getProcessScheduler();
    }

    public Set<ReportingTaskNode> getAllReportingTasks() {
        return Collections.emptySet();
    }

    public ControllerServiceNode createControllerService(String type, String id, BundleCoordinate bundleCoordinate, Set<URL> additionalUrls, boolean firstTimeAdded, boolean registerLogObserver, String classloaderIsolationKey) {
        logger.debug("Creating Controller Service of type {} with id {}", (Object)type, (Object)id);
        LogRepository logRepository = LogRepositoryFactory.getRepository((String)id);
        ControllerServiceNode serviceNode = new ComponentBuilder().identifier(id).type(type).bundleCoordinate(bundleCoordinate).statelessEngine(this.statelessEngine).additionalClassPathUrls(additionalUrls).buildControllerService();
        ControllerService service = serviceNode.getControllerServiceImplementation();
        ExtensionManager extensionManager = this.statelessEngine.getExtensionManager();
        try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ExtensionManager)extensionManager, (Class)service.getClass(), (String)service.getIdentifier());){
            StandardConfigurationContext configurationContext = new StandardConfigurationContext((ComponentNode)serviceNode, (ControllerServiceLookup)this.statelessEngine.getControllerServiceProvider(), null);
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnConfigurationRestored.class, (Object)service, (Object[])new Object[]{configurationContext});
        }
        ControllerService serviceImpl = serviceNode.getControllerServiceImplementation();
        try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ExtensionManager)extensionManager, (Class)serviceImpl.getClass(), (String)serviceImpl.getIdentifier());){
            ReflectionUtils.invokeMethodsWithAnnotation(OnAdded.class, (Object)serviceImpl, (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new ComponentLifeCycleException("Failed to invoke On-Added Lifecycle methods of " + String.valueOf(serviceImpl), (Throwable)e);
        }
        LogRepositoryFactory.getRepository((String)serviceNode.getIdentifier()).setLogger((ComponentLog)serviceNode.getLogger());
        if (registerLogObserver) {
            logRepository.addObserver(LogLevel.WARN, (LogObserver)new ControllerServiceLogObserver(this.bulletinRepository, serviceNode));
        }
        this.statelessEngine.getControllerServiceProvider().onControllerServiceAdded(serviceNode);
        logger.debug("Controller Service with id {} successfully created", (Object)id);
        return serviceNode;
    }

    public Set<ControllerServiceNode> getRootControllerServices() {
        return Collections.emptySet();
    }

    public void addRootControllerService(ControllerServiceNode serviceNode) {
        throw new UnsupportedOperationException("Root-Level Controller Services are not supported in Stateless NiFi");
    }

    public ControllerServiceNode getRootControllerService(String serviceIdentifier) {
        return null;
    }

    public void removeRootControllerService(ControllerServiceNode service) {
    }

    protected Authorizable getParameterContextParent() {
        return null;
    }

    public FlowAnalysisRuleNode createFlowAnalysisRule(String type, String id, BundleCoordinate bundleCoordinate, Set<URL> additionalUrls, boolean firstTimeAdded, boolean register, String classloaderIsolationKey) {
        return null;
    }
}

