/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.engine;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.components.validation.ValidationTrigger;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.controller.LoggableComponent;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.controller.ParameterProviderNode;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReloadComponent;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.StandardProcessorNode;
import org.apache.nifi.controller.TerminationAwareLogger;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.exception.ControllerServiceInstantiationException;
import org.apache.nifi.controller.exception.ProcessorInstantiationException;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.flowrepository.FlowRepositoryClientInstantiationException;
import org.apache.nifi.controller.kerberos.KerberosConfig;
import org.apache.nifi.controller.parameter.ParameterProviderInstantiationException;
import org.apache.nifi.controller.parameter.StandardParameterProviderNode;
import org.apache.nifi.controller.reporting.ReportingTaskInstantiationException;
import org.apache.nifi.controller.reporting.StandardReportingInitializationContext;
import org.apache.nifi.controller.reporting.StatelessReportingTaskNode;
import org.apache.nifi.controller.service.ControllerServiceInvocationHandler;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.StandardControllerServiceInitializationContext;
import org.apache.nifi.controller.service.StandardControllerServiceInvocationHandler;
import org.apache.nifi.controller.service.StandardControllerServiceNode;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.LoggingContext;
import org.apache.nifi.logging.StandardLoggingContext;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.InstanceClassLoader;
import org.apache.nifi.parameter.ParameterProvider;
import org.apache.nifi.parameter.ParameterProviderInitializationContext;
import org.apache.nifi.parameter.StandardParameterProviderInitializationContext;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.processor.StandardProcessorInitializationContext;
import org.apache.nifi.processor.StandardValidationContextFactory;
import org.apache.nifi.registry.flow.FlowRegistryClient;
import org.apache.nifi.registry.flow.FlowRegistryClientNode;
import org.apache.nifi.registry.flow.InMemoryFlowRegistry;
import org.apache.nifi.registry.flow.StandardFlowRegistryClientNode;
import org.apache.nifi.reporting.ReportingInitializationContext;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.stateless.engine.StatelessEngine;
import org.apache.nifi.stateless.engine.StatelessNodeTypeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ComponentBuilder.class);
    private StatelessEngine statelessEngine;
    private FlowManager flowManager;
    private String identifier;
    private String type;
    private BundleCoordinate bundleCoordinate;
    private Set<URL> additionalClassPathUrls;

    public ComponentBuilder statelessEngine(StatelessEngine statelessEngine) {
        this.statelessEngine = statelessEngine;
        return this;
    }

    public ComponentBuilder identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public ComponentBuilder type(String type) {
        this.type = type;
        return this;
    }

    public ComponentBuilder bundleCoordinate(BundleCoordinate bundleCoordinate) {
        this.bundleCoordinate = bundleCoordinate;
        return this;
    }

    public ComponentBuilder additionalClassPathUrls(Set<URL> urls) {
        if (urls == null || urls.isEmpty()) {
            return this;
        }
        if (this.additionalClassPathUrls == null) {
            this.additionalClassPathUrls = new HashSet<URL>();
        }
        this.additionalClassPathUrls.addAll(urls);
        return this;
    }

    public ComponentBuilder flowManager(FlowManager flowManager) {
        this.flowManager = flowManager;
        return this;
    }

    public ProcessorNode buildProcessor() throws ProcessorInstantiationException {
        LoggableComponent<Processor> loggableProcessor = this.createLoggableProcessor();
        ProcessScheduler processScheduler = this.statelessEngine.getProcessScheduler();
        ControllerServiceProvider controllerServiceProvider = this.statelessEngine.getControllerServiceProvider();
        ReloadComponent reloadComponent = this.statelessEngine.getReloadComponent();
        ExtensionManager extensionManager = this.statelessEngine.getExtensionManager();
        ValidationTrigger validationTrigger = this.statelessEngine.getValidationTrigger();
        StandardValidationContextFactory validationContextFactory = new StandardValidationContextFactory(controllerServiceProvider);
        StandardProcessorNode procNode = new StandardProcessorNode(loggableProcessor, this.identifier, (ValidationContextFactory)validationContextFactory, processScheduler, controllerServiceProvider, reloadComponent, extensionManager, validationTrigger);
        logger.info("Created Processor of type {} with identifier {}", (Object)this.type, (Object)this.identifier);
        return procNode;
    }

    public FlowRegistryClientNode buildFlowRegistryClient() throws FlowRepositoryClientInstantiationException {
        LoggableComponent<FlowRegistryClient> client = this.createLoggableFlowRegistryClient();
        ControllerServiceProvider controllerServiceProvider = this.statelessEngine.getControllerServiceProvider();
        ReloadComponent reloadComponent = this.statelessEngine.getReloadComponent();
        ExtensionManager extensionManager = this.statelessEngine.getExtensionManager();
        ValidationTrigger validationTrigger = this.statelessEngine.getValidationTrigger();
        StandardValidationContextFactory validationContextFactory = new StandardValidationContextFactory(controllerServiceProvider);
        StandardFlowRegistryClientNode clientNode = new StandardFlowRegistryClientNode(null, this.flowManager, client, this.identifier, (ValidationContextFactory)validationContextFactory, controllerServiceProvider, this.type, ((FlowRegistryClient)client.getComponent()).getClass().getCanonicalName(), reloadComponent, extensionManager, validationTrigger, false);
        logger.info("Flow Registry Client Node of type {} with identifier {}", (Object)this.type, (Object)this.identifier);
        return clientNode;
    }

    private LoggableComponent<FlowRegistryClient> createLoggableFlowRegistryClient() throws FlowRepositoryClientInstantiationException {
        try {
            SimpleProcessLogger componentLog = new SimpleProcessLogger(this.identifier, InMemoryFlowRegistry.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), (LoggingContext)new StandardLoggingContext(null));
            TerminationAwareLogger terminationAwareLogger = new TerminationAwareLogger((ComponentLog)componentLog);
            InMemoryFlowRegistry registryClient = new InMemoryFlowRegistry();
            LoggableComponent nodeComponent = new LoggableComponent((ConfigurableComponent)registryClient, this.bundleCoordinate, terminationAwareLogger);
            return nodeComponent;
        }
        catch (Exception e) {
            throw new FlowRepositoryClientInstantiationException(this.type, (Throwable)e);
        }
    }

    public ReportingTaskNode buildReportingTask() throws ReportingTaskInstantiationException {
        LoggableComponent<ReportingTask> reportingTaskComponent = this.createLoggableReportingTask();
        ProcessScheduler processScheduler = this.statelessEngine.getProcessScheduler();
        ControllerServiceProvider controllerServiceProvider = this.statelessEngine.getControllerServiceProvider();
        ReloadComponent reloadComponent = this.statelessEngine.getReloadComponent();
        ExtensionManager extensionManager = this.statelessEngine.getExtensionManager();
        ValidationTrigger validationTrigger = this.statelessEngine.getValidationTrigger();
        StandardValidationContextFactory validationContextFactory = new StandardValidationContextFactory(controllerServiceProvider);
        StatelessReportingTaskNode taskNode = new StatelessReportingTaskNode(reportingTaskComponent, this.identifier, this.statelessEngine, this.flowManager, processScheduler, (ValidationContextFactory)validationContextFactory, reloadComponent, extensionManager, validationTrigger);
        logger.info("Created Reporting Task of type {} with identifier {}", (Object)this.type, (Object)this.identifier);
        return taskNode;
    }

    private LoggableComponent<ReportingTask> createLoggableReportingTask() throws ReportingTaskInstantiationException {
        try {
            LoggableComponent<ReportingTask> taskComponent = this.createLoggableComponent(ReportingTask.class);
            String taskName = ((ReportingTask)taskComponent.getComponent()).getClass().getSimpleName();
            StatelessNodeTypeProvider nodeTypeProvider = new StatelessNodeTypeProvider();
            StandardReportingInitializationContext config = new StandardReportingInitializationContext(this.identifier, taskName, SchedulingStrategy.TIMER_DRIVEN, "1 min", (ComponentLog)taskComponent.getLogger(), this.statelessEngine.getControllerServiceProvider(), this.statelessEngine.getKerberosConfig(), (NodeTypeProvider)nodeTypeProvider);
            ((ReportingTask)taskComponent.getComponent()).initialize((ReportingInitializationContext)config);
            return taskComponent;
        }
        catch (Exception e) {
            throw new ReportingTaskInstantiationException(this.type, (Throwable)e);
        }
    }

    public ParameterProviderNode buildParameterProvider() throws ParameterProviderInstantiationException {
        LoggableComponent<ParameterProvider> parameterProviderComponent = this.createLoggableParameterProvider();
        ControllerServiceProvider controllerServiceProvider = this.statelessEngine.getControllerServiceProvider();
        ReloadComponent reloadComponent = this.statelessEngine.getReloadComponent();
        ExtensionManager extensionManager = this.statelessEngine.getExtensionManager();
        ValidationTrigger validationTrigger = this.statelessEngine.getValidationTrigger();
        StandardValidationContextFactory validationContextFactory = new StandardValidationContextFactory(controllerServiceProvider);
        StandardParameterProviderNode taskNode = new StandardParameterProviderNode(parameterProviderComponent, this.identifier, null, null, (ValidationContextFactory)validationContextFactory, reloadComponent, extensionManager, validationTrigger);
        logger.info("Created Reporting Task of type {} with identifier {}", (Object)this.type, (Object)this.identifier);
        return taskNode;
    }

    private LoggableComponent<ParameterProvider> createLoggableParameterProvider() throws ParameterProviderInstantiationException {
        try {
            LoggableComponent<ParameterProvider> taskComponent = this.createLoggableComponent(ParameterProvider.class);
            String taskName = ((ParameterProvider)taskComponent.getComponent()).getClass().getSimpleName();
            StatelessNodeTypeProvider nodeTypeProvider = new StatelessNodeTypeProvider();
            StandardParameterProviderInitializationContext config = new StandardParameterProviderInitializationContext(this.identifier, taskName, (ComponentLog)taskComponent.getLogger(), this.statelessEngine.getKerberosConfig(), (NodeTypeProvider)nodeTypeProvider);
            ((ParameterProvider)taskComponent.getComponent()).initialize((ParameterProviderInitializationContext)config);
            return taskComponent;
        }
        catch (Exception e) {
            throw new ParameterProviderInstantiationException(this.type, (Throwable)e);
        }
    }

    public ControllerServiceNode buildControllerService() {
        ExtensionManager extensionManager = this.statelessEngine.getExtensionManager();
        StateManagerProvider stateManagerProvider = this.statelessEngine.getStateManagerProvider();
        ControllerServiceProvider serviceProvider = this.statelessEngine.getControllerServiceProvider();
        KerberosConfig kerberosConfig = this.statelessEngine.getKerberosConfig();
        ReloadComponent reloadComponent = this.statelessEngine.getReloadComponent();
        ValidationTrigger validationTrigger = this.statelessEngine.getValidationTrigger();
        StatelessNodeTypeProvider nodeTypeProvider = new StatelessNodeTypeProvider();
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Bundle bundle = extensionManager.getBundle(this.bundleCoordinate);
            if (bundle == null) {
                List possibleBundles = extensionManager.getBundles(this.type);
                if (possibleBundles.size() == 1) {
                    bundle = (Bundle)possibleBundles.get(0);
                    logger.warn("Flow specifies bundle coordinates of {} for Controller Service of type {} but could not find that Bundle. Will use {} instead", new Object[]{this.bundleCoordinate, this.type, bundle});
                } else {
                    throw new IllegalStateException("Unable to find bundle for coordinate " + this.bundleCoordinate.getCoordinate());
                }
            }
            Set<Object> classpathUrls = this.additionalClassPathUrls == null ? Collections.emptySet() : this.additionalClassPathUrls;
            InstanceClassLoader detectedClassLoader = extensionManager.createInstanceClassLoader(this.type, this.identifier, bundle, classpathUrls);
            Class<?> rawClass = Class.forName(this.type, true, (ClassLoader)detectedClassLoader);
            Thread.currentThread().setContextClassLoader((ClassLoader)detectedClassLoader);
            Class<ControllerService> controllerServiceClass = rawClass.asSubclass(ControllerService.class);
            ControllerService serviceImpl = controllerServiceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            StandardControllerServiceInvocationHandler invocationHandler = new StandardControllerServiceInvocationHandler(extensionManager, serviceImpl);
            List interfaceList = ClassUtils.getAllInterfaces(controllerServiceClass);
            Class[] interfaces = interfaceList.toArray(new Class[0]);
            ControllerService proxiedService = detectedClassLoader == null ? (ControllerService)Proxy.newProxyInstance(this.getClass().getClassLoader(), interfaces, (InvocationHandler)invocationHandler) : (ControllerService)Proxy.newProxyInstance((ClassLoader)detectedClassLoader, interfaces, (InvocationHandler)invocationHandler);
            logger.info("Created Controller Service of type {} with identifier {}", (Object)this.type, (Object)this.identifier);
            SimpleProcessLogger serviceLogger = new SimpleProcessLogger(this.identifier, (Object)serviceImpl, (LoggingContext)new StandardLoggingContext(null));
            TerminationAwareLogger terminationAwareLogger = new TerminationAwareLogger((ComponentLog)serviceLogger);
            StateManager stateManager = stateManagerProvider.getStateManager(this.identifier);
            StandardControllerServiceInitializationContext initContext = new StandardControllerServiceInitializationContext(this.identifier, (ComponentLog)terminationAwareLogger, serviceProvider, stateManager, kerberosConfig, (NodeTypeProvider)nodeTypeProvider);
            serviceImpl.initialize((ControllerServiceInitializationContext)initContext);
            LoggableComponent originalLoggableComponent = new LoggableComponent((ConfigurableComponent)serviceImpl, this.bundleCoordinate, terminationAwareLogger);
            LoggableComponent proxiedLoggableComponent = new LoggableComponent((ConfigurableComponent)proxiedService, this.bundleCoordinate, terminationAwareLogger);
            StandardValidationContextFactory validationContextFactory = new StandardValidationContextFactory(serviceProvider);
            StandardControllerServiceNode serviceNode = new StandardControllerServiceNode(originalLoggableComponent, proxiedLoggableComponent, (ControllerServiceInvocationHandler)invocationHandler, this.identifier, (ValidationContextFactory)validationContextFactory, serviceProvider, reloadComponent, extensionManager, validationTrigger);
            serviceNode.setName(rawClass.getSimpleName());
            invocationHandler.setServiceNode((ControllerServiceNode)serviceNode);
            StandardControllerServiceNode standardControllerServiceNode = serviceNode;
            return standardControllerServiceNode;
        }
        catch (Exception e) {
            throw new ControllerServiceInstantiationException("Failed to create Controller Service of type " + this.type, (Throwable)e);
        }
        finally {
            if (ctxClassLoader != null) {
                Thread.currentThread().setContextClassLoader(ctxClassLoader);
            }
        }
    }

    private LoggableComponent<Processor> createLoggableProcessor() throws ProcessorInstantiationException {
        try {
            LoggableComponent<Processor> processorComponent = this.createLoggableComponent(Processor.class);
            StandardProcessorInitializationContext initiContext = new StandardProcessorInitializationContext(this.identifier, (ComponentLog)processorComponent.getLogger(), this.statelessEngine.getControllerServiceProvider(), (NodeTypeProvider)new StatelessNodeTypeProvider(), this.statelessEngine.getKerberosConfig());
            ((Processor)processorComponent.getComponent()).initialize((ProcessorInitializationContext)initiContext);
            return processorComponent;
        }
        catch (Exception e) {
            throw new ProcessorInstantiationException(this.type, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ConfigurableComponent> LoggableComponent<T> createLoggableComponent(Class<T> nodeType) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ExtensionManager extensionManager = this.statelessEngine.getExtensionManager();
            Bundle bundle = extensionManager.getBundle(this.bundleCoordinate);
            if (bundle == null) {
                List possibleBundles = extensionManager.getBundles(this.type);
                if (possibleBundles.size() == 1) {
                    bundle = (Bundle)possibleBundles.get(0);
                    logger.warn("Flow specifies bundle coordinates of {} for {} of type {} but could not find that Bundle. Will use {} instead", new Object[]{this.bundleCoordinate, nodeType.getSimpleName(), this.type, bundle});
                } else {
                    throw new IllegalStateException("Unable to find bundle for coordinate " + this.bundleCoordinate.getCoordinate());
                }
            }
            Set<Object> classpathUrls = this.additionalClassPathUrls == null ? Collections.emptySet() : this.additionalClassPathUrls;
            InstanceClassLoader detectedClassLoader = extensionManager.createInstanceClassLoader(this.type, this.identifier, bundle, classpathUrls);
            Class<?> rawClass = Class.forName(this.type, true, (ClassLoader)detectedClassLoader);
            Thread.currentThread().setContextClassLoader((ClassLoader)detectedClassLoader);
            Object extensionInstance = rawClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            SimpleProcessLogger componentLog = new SimpleProcessLogger(this.identifier, extensionInstance, (LoggingContext)new StandardLoggingContext(null));
            TerminationAwareLogger terminationAwareLogger = new TerminationAwareLogger((ComponentLog)componentLog);
            ConfigurableComponent cast = (ConfigurableComponent)nodeType.cast(extensionInstance);
            LoggableComponent loggableComponent = new LoggableComponent(cast, this.bundleCoordinate, terminationAwareLogger);
            return loggableComponent;
        }
        finally {
            if (ctxClassLoader != null) {
                Thread.currentThread().setContextClassLoader(ctxClassLoader);
            }
        }
    }
}

