/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql.datasources;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.util.provenance.ComponentMapHolder;
import org.apache.nifi.sql.ArrayType;
import org.apache.nifi.sql.ColumnSchema;
import org.apache.nifi.sql.ColumnType;
import org.apache.nifi.sql.MapType;
import org.apache.nifi.sql.NiFiTableSchema;
import org.apache.nifi.sql.ResettableDataSource;
import org.apache.nifi.sql.RowStream;
import org.apache.nifi.sql.ScalarType;

public class ProvenanceDataSource
implements ResettableDataSource {
    public static final NiFiTableSchema SCHEMA = new NiFiTableSchema(List.of(new ColumnSchema("eventId", Long.TYPE, false), new ColumnSchema("eventType", String.class, false), new ColumnSchema("timestampMillis", Long.TYPE, true), new ColumnSchema("durationMillis", Long.TYPE, true), new ColumnSchema("lineageStart", Long.TYPE, true), new ColumnSchema("details", String.class, true), new ColumnSchema("componentId", String.class, true), new ColumnSchema("componentName", String.class, true), new ColumnSchema("componentType", String.class, true), new ColumnSchema("processGroupId", String.class, true), new ColumnSchema("processGroupName", String.class, true), new ColumnSchema("entityId", String.class, true), new ColumnSchema("entityType", String.class, true), new ColumnSchema("entitySize", Long.TYPE, true), new ColumnSchema("previousEntitySize", Long.TYPE, true), new ColumnSchema("updatedAttributes", (ColumnType)new MapType((ColumnType)ScalarType.STRING, (ColumnType)ScalarType.STRING), true), new ColumnSchema("previousAttributes", (ColumnType)new MapType((ColumnType)ScalarType.STRING, (ColumnType)ScalarType.STRING), true), new ColumnSchema("contentPath", String.class, true), new ColumnSchema("previousContentPath", String.class, true), new ColumnSchema("parentIds", (ColumnType)new ArrayType((ColumnType)ScalarType.STRING), true), new ColumnSchema("childIds", (ColumnType)new ArrayType((ColumnType)ScalarType.STRING), true), new ColumnSchema("transitUri", String.class, true), new ColumnSchema("remoteIdentifier", String.class, true), new ColumnSchema("alternateIdentifier", String.class, true)));
    private static final String ENTITY_TYPE = "org.apache.nifi.flowfile.FlowFile";
    private static final int FETCH_SIZE = 1000;
    private final ReportingContext reportingContext;
    private final ComponentMapHolder componentMapHolder;
    private Iterator<ProvenanceEventRecord> iterator;
    private long lastId = -1L;

    public ProvenanceDataSource(ReportingContext reportingContext) {
        this.reportingContext = reportingContext;
        ProcessGroupStatus procGroupStatus = reportingContext.getEventAccess().getControllerStatus();
        this.componentMapHolder = ComponentMapHolder.createComponentMap((ProcessGroupStatus)procGroupStatus);
    }

    public NiFiTableSchema getSchema() {
        return SCHEMA;
    }

    public RowStream reset() throws IOException {
        this.lastId = -1L;
        this.iterator = null;
        return new RowStream(){

            public Object[] nextRow() throws IOException {
                if (ProvenanceDataSource.this.iterator == null || !ProvenanceDataSource.this.iterator.hasNext()) {
                    ProvenanceDataSource.this.iterator = ProvenanceDataSource.this.fetchEvents();
                }
                if (ProvenanceDataSource.this.iterator.hasNext()) {
                    ProvenanceEventRecord event = ProvenanceDataSource.this.iterator.next();
                    ProvenanceDataSource.this.lastId = event.getEventId();
                    return ProvenanceDataSource.this.toArray(event);
                }
                return null;
            }

            public void close() {
            }
        };
    }

    private Object[] toArray(ProvenanceEventRecord provenanceEvent) {
        String nodeIdentifier = this.reportingContext.getClusterNodeIdentifier();
        String processGroupId = this.componentMapHolder.getProcessGroupId(provenanceEvent.getComponentId(), provenanceEvent.getComponentType());
        String groupName = this.componentMapHolder.getComponentName(processGroupId);
        ArrayList<Object> rowList = new ArrayList<Object>();
        rowList.add(provenanceEvent.getEventId());
        rowList.add(provenanceEvent.getEventType().name());
        rowList.add(provenanceEvent.getEventTime());
        rowList.add(provenanceEvent.getEventDuration());
        rowList.add(provenanceEvent.getLineageStartDate());
        rowList.add(provenanceEvent.getDetails());
        rowList.add(provenanceEvent.getComponentId());
        rowList.add(this.componentMapHolder.getComponentName(provenanceEvent.getComponentId()));
        rowList.add(provenanceEvent.getComponentType());
        rowList.add(processGroupId);
        rowList.add(groupName);
        rowList.add(provenanceEvent.getFlowFileUuid());
        rowList.add(ENTITY_TYPE);
        rowList.add(provenanceEvent.getFileSize());
        rowList.add(provenanceEvent.getPreviousFileSize());
        rowList.add(provenanceEvent.getUpdatedAttributes());
        rowList.add(provenanceEvent.getPreviousAttributes());
        if (nodeIdentifier != null) {
            String contentPathBase = "/nifi-api/provenance-events/" + provenanceEvent.getEventId() + "/content/";
            String nodeIdSuffix = "?clusterNodeId=" + nodeIdentifier;
            rowList.add(contentPathBase + "output" + nodeIdSuffix);
            rowList.add(contentPathBase + "input" + nodeIdSuffix);
        } else {
            rowList.add(null);
            rowList.add(null);
        }
        rowList.add(provenanceEvent.getParentUuids());
        rowList.add(provenanceEvent.getChildUuids());
        rowList.add(provenanceEvent.getTransitUri());
        rowList.add(provenanceEvent.getSourceSystemFlowFileIdentifier());
        rowList.add(provenanceEvent.getAlternateIdentifierUri());
        return rowList.toArray();
    }

    private Iterator<ProvenanceEventRecord> fetchEvents() throws IOException {
        List events = this.reportingContext.getEventAccess().getProvenanceEvents(this.lastId + 1L, 1000);
        return events.iterator();
    }
}

