/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql.provenance;

import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.nifi.reporting.sql.provenance.ProvenanceTableScan;

public class ProvenanceProjectTableScanRule
extends RelOptRule {
    public static final ProvenanceProjectTableScanRule INSTANCE = new ProvenanceProjectTableScanRule();

    private ProvenanceProjectTableScanRule() {
        super(ProvenanceProjectTableScanRule.operand(LogicalProject.class, (RelOptRuleOperand)ProvenanceProjectTableScanRule.operand(ProvenanceTableScan.class, (RelOptRuleOperandChildren)ProvenanceProjectTableScanRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "ProvenanceProjectTableScanRule");
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalProject project = (LogicalProject)call.rel(0);
        ProvenanceTableScan scan = (ProvenanceTableScan)call.rel(1);
        int[] fields = this.getProjectFields(project.getProjects());
        if (fields == null) {
            return;
        }
        call.transformTo((RelNode)new ProvenanceTableScan(scan.getCluster(), scan.getTable(), scan.provenanceTable, fields));
    }

    private int[] getProjectFields(List<RexNode> exps) {
        int[] fields = new int[exps.size()];
        for (int i = 0; i < exps.size(); ++i) {
            RexNode exp = exps.get(i);
            if (!(exp instanceof RexInputRef)) {
                return null;
            }
            fields[i] = ((RexInputRef)exp).getIndex();
        }
        return fields;
    }
}

