/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql.connectionstatuspredictions;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.util.Pair;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.sql.connectionstatuspredictions.ConnectionStatusPredictionsEnumerator;
import org.apache.nifi.reporting.sql.connectionstatuspredictions.ConnectionStatusPredictionsTableScan;

public class ConnectionStatusPredictionsTable
extends AbstractTable
implements QueryableTable,
TranslatableTable {
    private final ComponentLog logger;
    private RelDataType relDataType = null;
    private volatile ReportingContext context;
    private volatile int maxRecordsRead;
    private final Set<ConnectionStatusPredictionsEnumerator> enumerators = new HashSet<ConnectionStatusPredictionsEnumerator>();

    public ConnectionStatusPredictionsTable(ReportingContext context, ComponentLog logger) {
        this.context = context;
        this.logger = logger;
    }

    public String toString() {
        return "ConnectionStatusPredictionsTable";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Set<ConnectionStatusPredictionsEnumerator> set = this.enumerators;
        synchronized (set) {
            for (ConnectionStatusPredictionsEnumerator enumerator : this.enumerators) {
                enumerator.close();
            }
        }
    }

    public Enumerable<Object> project(final int[] fields) {
        return new AbstractEnumerable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Enumerator<Object> enumerator() {
                ConnectionStatusPredictionsEnumerator connectionStatusPredictionsEnumerator = new ConnectionStatusPredictionsEnumerator(ConnectionStatusPredictionsTable.this.context, ConnectionStatusPredictionsTable.this.logger, fields){

                    @Override
                    protected void onFinish() {
                        int recordCount = this.getRecordsRead();
                        if (recordCount > ConnectionStatusPredictionsTable.this.maxRecordsRead) {
                            ConnectionStatusPredictionsTable.this.maxRecordsRead = recordCount;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void close() {
                        Set set = ConnectionStatusPredictionsTable.this.enumerators;
                        synchronized (set) {
                            ConnectionStatusPredictionsTable.this.enumerators.remove(this);
                        }
                        super.close();
                    }
                };
                Set set = ConnectionStatusPredictionsTable.this.enumerators;
                synchronized (set) {
                    ConnectionStatusPredictionsTable.this.enumerators.add(connectionStatusPredictionsEnumerator);
                }
                return connectionStatusPredictionsEnumerator;
            }
        };
    }

    public int getRecordsRead() {
        return this.maxRecordsRead;
    }

    public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
        return Schemas.tableExpression((SchemaPlus)schema, (Type)this.getElementType(), (String)tableName, (Class)clazz);
    }

    public Type getElementType() {
        return Object[].class;
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        throw new UnsupportedOperationException();
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        int fieldCount = relOptTable.getRowType().getFieldCount();
        int[] fields = new int[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            fields[i] = i;
        }
        return new ConnectionStatusPredictionsTableScan(context.getCluster(), relOptTable, this, fields);
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.relDataType != null) {
            return this.relDataType;
        }
        List<String> names = Arrays.asList("connectionId", "predictedQueuedBytes", "predictedQueuedCount", "predictedPercentBytes", "predictedPercentCount", "predictedTimeToBytesBackpressureMillis", "predictedTimeToCountBackpressureMillis", "predictionIntervalMillis");
        List<RelDataType> types = Arrays.asList(typeFactory.createJavaType(String.class), typeFactory.createJavaType(Long.TYPE), typeFactory.createJavaType(Integer.TYPE), typeFactory.createJavaType(Integer.TYPE), typeFactory.createJavaType(Integer.TYPE), typeFactory.createJavaType(Long.TYPE), typeFactory.createJavaType(Long.TYPE), typeFactory.createJavaType(Long.TYPE));
        this.relDataType = typeFactory.createStructType(Pair.zip(names, types));
        return this.relDataType;
    }

    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.TEMPORARY_TABLE;
    }
}

