/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.repository;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.security.kms.EncryptionException;
import org.apache.nifi.security.kms.KeyProvider;
import org.apache.nifi.security.repository.RepositoryEncryptorUtils;
import org.apache.nifi.security.repository.RepositoryObjectEncryptionMetadata;
import org.apache.nifi.security.repository.RepositoryObjectEncryptor;
import org.apache.nifi.security.util.crypto.AESKeyedCipherProvider;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAESEncryptor
implements RepositoryObjectEncryptor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAESEncryptor.class);
    private static final byte[] EM_START_SENTINEL = new byte[]{0, 0};
    private static final byte[] EM_END_SENTINEL = new byte[]{-1, -1};
    private static String ALGORITHM = "AES/CTR/NoPadding";
    protected static final int IV_LENGTH = 16;
    protected static final byte[] EMPTY_IV = new byte[16];
    protected KeyProvider keyProvider;
    protected AESKeyedCipherProvider aesKeyedCipherProvider = new AESKeyedCipherProvider();

    @Override
    public void initialize(KeyProvider keyProvider) throws KeyManagementException {
        this.keyProvider = keyProvider;
        if (this.aesKeyedCipherProvider == null) {
            this.aesKeyedCipherProvider = new AESKeyedCipherProvider();
        }
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    void setCipherProvider(AESKeyedCipherProvider cipherProvider) {
        this.aesKeyedCipherProvider = cipherProvider;
    }

    public static RepositoryObjectEncryptionMetadata prepareObjectForDecryption(Object ciphertextSource, String identifier, String descriptor, List<String> supportedVersions) throws EncryptionException {
        RepositoryObjectEncryptionMetadata metadata;
        block6: {
            if (ciphertextSource == null) {
                throw new EncryptionException("The encrypted " + descriptor + " cannot be missing");
            }
            try {
                if (ciphertextSource instanceof InputStream) {
                    logger.debug("Detected encrypted input stream for {} with ID {}", (Object)descriptor, (Object)identifier);
                    InputStream ciphertextStream = (InputStream)ciphertextSource;
                    metadata = RepositoryEncryptorUtils.extractEncryptionMetadata(ciphertextStream);
                    break block6;
                }
                if (ciphertextSource instanceof byte[]) {
                    logger.debug("Detected byte[] for {} with ID {}", (Object)descriptor, (Object)identifier);
                    byte[] ciphertextBytes = (byte[])ciphertextSource;
                    metadata = RepositoryEncryptorUtils.extractEncryptionMetadata(ciphertextBytes);
                    break block6;
                }
                String errorMsg = "The " + descriptor + " with ID " + identifier + " was detected as " + ciphertextSource.getClass().getSimpleName() + "; this is not a supported source of ciphertext";
                logger.error(errorMsg);
                throw new EncryptionException(errorMsg);
            }
            catch (IOException | ClassNotFoundException e) {
                String msg = "Encountered an error reading the encryption metadata: ";
                logger.error("Encountered an error reading the encryption metadata: ", (Throwable)e);
                throw new EncryptionException("Encountered an error reading the encryption metadata: ", e);
            }
        }
        if (!supportedVersions.contains(metadata.version)) {
            throw new EncryptionException("The " + descriptor + " with ID " + identifier + " was encrypted with version " + metadata.version + " which is not in the list of supported versions " + StringUtils.join(supportedVersions, (String)","));
        }
        return metadata;
    }
}

