/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.script;

import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.annotation.lifecycle.OnConfigurationRestored;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.script.ScriptRunner;
import org.apache.nifi.script.ScriptingComponentHelper;
import org.apache.nifi.script.ScriptingComponentUtils;
import org.apache.nifi.util.StringUtils;

public abstract class AbstractScriptedControllerService
extends AbstractControllerService {
    protected final AtomicReference<Collection<ValidationResult>> validationResults = new AtomicReference(new ArrayList());
    protected final AtomicBoolean scriptNeedsReload = new AtomicBoolean(true);
    protected volatile ScriptRunner scriptRunner = null;
    protected volatile ScriptingComponentHelper scriptingComponentHelper = new ScriptingComponentHelper();
    protected volatile ConfigurationContext configurationContext = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        AtomicBoolean atomicBoolean = this.scriptingComponentHelper.isInitialized;
        synchronized (atomicBoolean) {
            if (!this.scriptingComponentHelper.isInitialized.get()) {
                this.scriptingComponentHelper.createResources();
            }
        }
        ArrayList<PropertyDescriptor> supportedPropertyDescriptors = new ArrayList<PropertyDescriptor>(this.scriptingComponentHelper.getDescriptors());
        return Collections.unmodifiableList(supportedPropertyDescriptors);
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).dynamic(true).build();
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        this.validationResults.set(new HashSet());
        if (ScriptingComponentUtils.SCRIPT_FILE.equals((Object)descriptor) || ScriptingComponentUtils.SCRIPT_BODY.equals((Object)descriptor) || ScriptingComponentUtils.MODULES.equals((Object)descriptor) || this.scriptingComponentHelper.SCRIPT_ENGINE.equals((Object)descriptor)) {
            this.scriptNeedsReload.set(true);
            if (this.scriptingComponentHelper.SCRIPT_ENGINE.equals((Object)descriptor) || ScriptingComponentUtils.MODULES.equals((Object)descriptor)) {
                this.scriptRunner = null;
            }
        }
    }

    @OnConfigurationRestored
    public void onConfigurationRestored(ConfigurationContext context) {
        this.scriptingComponentHelper.setupVariables((PropertyContext)context);
        this.setup();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> commonValidationResults = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        commonValidationResults.addAll(this.scriptingComponentHelper.customValidate(validationContext));
        if (!commonValidationResults.isEmpty()) {
            return commonValidationResults;
        }
        if (!this.validationResults.get().isEmpty()) {
            return this.validationResults.get();
        }
        return commonValidationResults;
    }

    public void onEnabled(ConfigurationContext context) {
        this.configurationContext = context;
        this.scriptingComponentHelper.setupVariables((PropertyContext)context);
        this.setup();
    }

    public abstract void setup();

    protected boolean reloadScriptFile(String scriptPath) {
        boolean bl;
        if (StringUtils.isEmpty((String)scriptPath)) {
            return false;
        }
        HashSet<ValidationResult> results = new HashSet<ValidationResult>();
        FileInputStream scriptStream = new FileInputStream(scriptPath);
        try {
            bl = this.reloadScript(IOUtils.toString((InputStream)scriptStream, (Charset)Charset.defaultCharset()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    scriptStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                ComponentLog logger = this.getLogger();
                String message = "Unable to load script: " + String.valueOf(e);
                logger.error(message, (Throwable)e);
                results.add(new ValidationResult.Builder().subject("ScriptValidation").valid(false).explanation("Unable to load script due to " + String.valueOf(e)).input(scriptPath).build());
                this.validationResults.set(results);
                return !results.isEmpty();
            }
        }
        scriptStream.close();
        return bl;
    }

    protected boolean reloadScriptBody(String scriptBody) {
        if (StringUtils.isEmpty((String)scriptBody)) {
            return false;
        }
        HashSet<ValidationResult> results = new HashSet<ValidationResult>();
        try {
            return this.reloadScript(scriptBody);
        }
        catch (Exception e) {
            ComponentLog logger = this.getLogger();
            String message = "Unable to load script: " + String.valueOf(e);
            logger.error(message, (Throwable)e);
            results.add(new ValidationResult.Builder().subject("ScriptValidation").valid(false).explanation("Unable to load script due to " + String.valueOf(e)).input(this.scriptingComponentHelper.getScriptPath()).build());
            this.validationResults.set(results);
            return results.isEmpty();
        }
    }

    protected abstract boolean reloadScript(String var1);
}

