/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.script;

import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.script.ScriptEngine;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.script.ScriptingComponentHelper;
import org.apache.nifi.script.ScriptingComponentUtils;

public abstract class AbstractScriptedControllerService
extends AbstractControllerService {
    protected final AtomicReference<Collection<ValidationResult>> validationResults = new AtomicReference(new ArrayList());
    protected final AtomicBoolean scriptNeedsReload = new AtomicBoolean(true);
    protected volatile ScriptEngine scriptEngine = null;
    protected volatile ScriptingComponentHelper scriptingComponentHelper = new ScriptingComponentHelper();
    protected volatile ConfigurationContext configurationContext = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        AtomicBoolean atomicBoolean = this.scriptingComponentHelper.isInitialized;
        synchronized (atomicBoolean) {
            if (!this.scriptingComponentHelper.isInitialized.get()) {
                this.scriptingComponentHelper.createResources();
            }
        }
        ArrayList<PropertyDescriptor> supportedPropertyDescriptors = new ArrayList<PropertyDescriptor>();
        supportedPropertyDescriptors.addAll(this.scriptingComponentHelper.getDescriptors());
        return Collections.unmodifiableList(supportedPropertyDescriptors);
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).dynamic(true).build();
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (ScriptingComponentUtils.SCRIPT_FILE.equals((Object)descriptor) || ScriptingComponentUtils.SCRIPT_BODY.equals((Object)descriptor) || ScriptingComponentUtils.MODULES.equals((Object)descriptor) || this.scriptingComponentHelper.SCRIPT_ENGINE.equals((Object)descriptor)) {
            this.scriptNeedsReload.set(true);
            if (this.scriptingComponentHelper.SCRIPT_ENGINE.equals((Object)descriptor)) {
                this.scriptEngine = null;
            }
        }
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        return this.scriptingComponentHelper.customValidate(validationContext);
    }

    public void onEnabled(ConfigurationContext context) {
        this.configurationContext = context;
        this.scriptingComponentHelper.setupVariables(context);
        this.setup();
    }

    public abstract void setup();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean reloadScriptFile(String scriptPath) {
        HashSet<ValidationResult> results = new HashSet<ValidationResult>();
        try (FileInputStream scriptStream = new FileInputStream(scriptPath);){
            boolean throwable3 = this.reloadScript(IOUtils.toString((InputStream)scriptStream, (Charset)Charset.defaultCharset()));
            return throwable3;
        }
        catch (Exception e) {
            ComponentLog logger = this.getLogger();
            String message = "Unable to load script: " + e;
            logger.error(message, (Throwable)e);
            results.add(new ValidationResult.Builder().subject("ScriptValidation").valid(false).explanation("Unable to load script due to " + e).input(scriptPath).build());
            this.validationResults.set(results);
            return results.isEmpty();
        }
    }

    protected boolean reloadScriptBody(String scriptBody) {
        HashSet<ValidationResult> results = new HashSet<ValidationResult>();
        try {
            return this.reloadScript(scriptBody);
        }
        catch (Exception e) {
            ComponentLog logger = this.getLogger();
            String message = "Unable to load script: " + e;
            logger.error(message, (Throwable)e);
            results.add(new ValidationResult.Builder().subject("ScriptValidation").valid(false).explanation("Unable to load script due to " + e).input(this.scriptingComponentHelper.getScriptPath()).build());
            this.validationResults.set(results);
            return results.isEmpty();
        }
    }

    protected abstract boolean reloadScript(String var1);
}

