/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.script;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.metrics.jvm.JmxJvmMetrics;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.script.ScriptEngineConfigurator;
import org.apache.nifi.reporting.AbstractReportingTask;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.script.ScriptingComponentHelper;

@Tags(value={"reporting", "script", "execute", "groovy", "python", "jython", "jruby", "ruby", "javascript", "js", "lua", "luaj"})
@CapabilityDescription(value="Provides reporting and status information to a script. ReportingContext, ComponentLog, and VirtualMachineMetrics objects are made available as variables (context, log, and vmMetrics, respectively) to the script for further processing. The context makes various information available such as events, provenance, bulletins, controller services, process groups, Java Virtual Machine metrics, etc.")
@DynamicProperty(name="A script engine property to update", value="The value to set it to", expressionLanguageScope=ExpressionLanguageScope.VARIABLE_REGISTRY, description="Updates a script engine property specified by the Dynamic Property's key with the value specified by the Dynamic Property's value")
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.EXECUTE_CODE, explanation="Provides operator the ability to execute arbitrary code assuming all permissions that NiFi has.")})
public class ScriptedReportingTask
extends AbstractReportingTask {
    protected volatile ScriptingComponentHelper scriptingComponentHelper = new ScriptingComponentHelper();
    private volatile String scriptToRun = null;
    private volatile JmxJvmMetrics vmMetrics;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        AtomicBoolean atomicBoolean = this.scriptingComponentHelper.isInitialized;
        synchronized (atomicBoolean) {
            if (!this.scriptingComponentHelper.isInitialized.get()) {
                this.scriptingComponentHelper.createResources();
            }
        }
        return Collections.unmodifiableList(this.scriptingComponentHelper.getDescriptors());
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).dynamic(true).build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        return this.scriptingComponentHelper.customValidate(validationContext);
    }

    @OnScheduled
    public void setup(ConfigurationContext context) {
        block14: {
            this.scriptingComponentHelper.setupVariables(context);
            this.scriptingComponentHelper.setup(1, this.getLogger());
            this.scriptToRun = this.scriptingComponentHelper.getScriptBody();
            try {
                String scriptPath = this.scriptingComponentHelper.getScriptPath();
                if (this.scriptToRun != null || scriptPath == null) break block14;
                try (FileInputStream scriptStream = new FileInputStream(scriptPath);){
                    this.scriptToRun = IOUtils.toString((InputStream)scriptStream, (Charset)Charset.defaultCharset());
                }
            }
            catch (IOException ioe) {
                throw new ProcessException((Throwable)ioe);
            }
        }
        this.vmMetrics = JmxJvmMetrics.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ReportingContext context) {
        AtomicBoolean atomicBoolean = this.scriptingComponentHelper.isInitialized;
        synchronized (atomicBoolean) {
            if (!this.scriptingComponentHelper.isInitialized.get()) {
                this.scriptingComponentHelper.createResources();
            }
        }
        ScriptEngine scriptEngine = (ScriptEngine)this.scriptingComponentHelper.engineQ.poll();
        ComponentLog log = this.getLogger();
        if (scriptEngine == null) {
            return;
        }
        try {
            try {
                Bindings bindings = scriptEngine.getBindings(100);
                if (bindings == null) {
                    bindings = new SimpleBindings();
                }
                bindings.put("context", (Object)context);
                bindings.put("log", (Object)log);
                bindings.put("vmMetrics", (Object)this.vmMetrics);
                for (Map.Entry property : context.getProperties().entrySet()) {
                    if (!((PropertyDescriptor)property.getKey()).isDynamic() || property.getValue() == null) continue;
                    bindings.put(((PropertyDescriptor)property.getKey()).getName(), (Object)context.getProperty((PropertyDescriptor)property.getKey()));
                }
                scriptEngine.setBindings(bindings, 100);
                ScriptEngineConfigurator configurator = this.scriptingComponentHelper.scriptEngineConfiguratorMap.get(this.scriptingComponentHelper.getScriptEngineName().toLowerCase());
                if (configurator != null) {
                    configurator.eval(scriptEngine, this.scriptToRun, this.scriptingComponentHelper.getModules());
                } else {
                    scriptEngine.eval(this.scriptToRun);
                }
            }
            catch (ScriptException e) {
                throw new ProcessException((Throwable)e);
            }
        }
        catch (Throwable t) {
            this.getLogger().error("{} failed to process due to {}; rolling back session", new Object[]{this, t});
            throw t;
        }
        finally {
            this.scriptingComponentHelper.engineQ.offer(scriptEngine);
        }
    }
}

