/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util.put.sender;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.put.sender.SocketChannelSender;
import org.apache.nifi.remote.io.socket.ssl.SSLSocketChannel;
import org.apache.nifi.remote.io.socket.ssl.SSLSocketChannelOutputStream;

public class SSLSocketChannelSender
extends SocketChannelSender {
    private SSLContext sslContext;
    private SSLSocketChannel sslChannel;
    private SSLSocketChannelOutputStream sslOutputStream;

    public SSLSocketChannelSender(String host, int port, int maxSendBufferSize, SSLContext sslContext, ComponentLog logger) {
        super(host, port, maxSendBufferSize, logger);
        this.sslContext = sslContext;
    }

    @Override
    public void open() throws IOException {
        if (this.sslChannel == null) {
            super.open();
            this.sslChannel = new SSLSocketChannel(this.sslContext, this.channel, true);
        }
        this.sslChannel.setTimeout(this.timeout);
        this.sslChannel.connect();
        this.sslOutputStream = new SSLSocketChannelOutputStream(this.sslChannel);
    }

    @Override
    protected void write(byte[] data) throws IOException {
        this.sslChannel.write(data);
    }

    @Override
    public boolean isConnected() {
        return this.sslChannel != null && !this.sslChannel.isClosed();
    }

    @Override
    public void close() {
        super.close();
        IOUtils.closeQuietly((OutputStream)this.sslOutputStream);
        IOUtils.closeQuietly((Closeable)this.sslChannel);
        this.sslChannel = null;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.sslOutputStream;
    }
}

