/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util.listen;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;

public class ListenerProperties {
    private static final Set<String> interfaceSet = new HashSet<String>();
    public static final PropertyDescriptor NETWORK_INTF_NAME;

    static {
        try {
            Enumeration<NetworkInterface> interfaceEnum = NetworkInterface.getNetworkInterfaces();
            while (interfaceEnum.hasMoreElements()) {
                NetworkInterface ifc = interfaceEnum.nextElement();
                interfaceSet.add(ifc.getName());
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        NETWORK_INTF_NAME = new PropertyDescriptor.Builder().name("Local Network Interface").description("The name of a local network interface to be used to restrict listening to a specific LAN.").addValidator(new Validator(){

            public ValidationResult validate(String subject, String input, ValidationContext context) {
                String message;
                ValidationResult result = new ValidationResult.Builder().subject("Local Network Interface").valid(true).input(input).build();
                if (interfaceSet.contains(input.toLowerCase())) {
                    return result;
                }
                String realValue = input;
                try {
                    if (context.isExpressionLanguagePresent(input)) {
                        AttributeExpression ae = context.newExpressionLanguageCompiler().compile(input);
                        realValue = ae.evaluate();
                    }
                    if (interfaceSet.contains(realValue.toLowerCase())) {
                        return result;
                    }
                    message = realValue + " is not a valid network name. Valid names are " + interfaceSet.toString();
                }
                catch (IllegalArgumentException e) {
                    message = "Not a valid AttributeExpression: " + e.getMessage();
                }
                result = new ValidationResult.Builder().subject("Local Network Interface").valid(false).input(input).explanation(message).build();
                return result;
            }
        }).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    }
}

