/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.network.parser;

import java.util.OptionalInt;
import org.apache.nifi.processors.network.parser.util.ConversionUtil;

public final class Netflowv5Parser {
    private static final int HEADER_SIZE = 24;
    private static final int RECORD_SIZE = 48;
    private static final int SHORT_TYPE = 0;
    private static final int INTEGER_TYPE = 1;
    private static final int LONG_TYPE = 2;
    private static final int IPV4_TYPE = 3;
    private static final String[] headerField = new String[]{"version", "count", "sys_uptime", "unix_secs", "unix_nsecs", "flow_sequence", "engine_type", "engine_id", "sampling_interval"};
    private static final String[] recordField = new String[]{"srcaddr", "dstaddr", "nexthop", "input", "output", "dPkts", "dOctets", "first", "last", "srcport", "dstport", "pad1", "tcp_flags", "prot", "tos", "src_as", "dst_as", "src_mask", "dst_mask", "pad2"};
    private final int portNumber;
    private Object[] headerData;
    private Object[][] recordData;

    public Netflowv5Parser(OptionalInt portNumber) {
        this.portNumber = portNumber.isPresent() ? portNumber.getAsInt() : 0;
    }

    public int parse(byte[] buffer) throws Throwable {
        if (!this.isValid(buffer.length)) {
            throw new Exception("Invalid Packet Length");
        }
        int version = ConversionUtil.toInt(buffer, 0, 2);
        if (version != 5) {
            throw new Exception("Version mismatch");
        }
        int count = ConversionUtil.toInt(buffer, 2, 2);
        this.headerData = new Object[headerField.length];
        this.headerData[0] = version;
        this.headerData[1] = count;
        this.headerData[2] = this.parseField(buffer, 4, 4, 2);
        this.headerData[3] = this.parseField(buffer, 8, 4, 2);
        this.headerData[4] = this.parseField(buffer, 12, 4, 2);
        this.headerData[5] = this.parseField(buffer, 16, 4, 2);
        this.headerData[6] = this.parseField(buffer, 20, 1, 0);
        this.headerData[7] = this.parseField(buffer, 21, 1, 0);
        this.headerData[8] = this.parseField(buffer, 22, 2, 1);
        int offset = 0;
        this.recordData = new Object[count][recordField.length];
        for (int counter = 0; counter < count; ++counter) {
            offset = 24 + counter * 48;
            this.recordData[counter][0] = this.parseField(buffer, offset, 4, 3);
            this.recordData[counter][1] = this.parseField(buffer, offset + 4, 4, 3);
            this.recordData[counter][2] = this.parseField(buffer, offset + 8, 4, 3);
            this.recordData[counter][3] = this.parseField(buffer, offset + 12, 2, 1);
            this.recordData[counter][4] = this.parseField(buffer, offset + 14, 2, 1);
            this.recordData[counter][5] = this.parseField(buffer, offset + 16, 4, 2);
            this.recordData[counter][6] = this.parseField(buffer, offset + 20, 4, 2);
            this.recordData[counter][7] = this.parseField(buffer, offset + 24, 4, 2);
            this.recordData[counter][8] = this.parseField(buffer, offset + 28, 4, 2);
            this.recordData[counter][9] = this.parseField(buffer, offset + 32, 2, 1);
            this.recordData[counter][10] = this.parseField(buffer, offset + 34, 2, 1);
            this.recordData[counter][11] = this.parseField(buffer, offset + 36, 1, 0);
            this.recordData[counter][12] = this.parseField(buffer, offset + 37, 1, 0);
            this.recordData[counter][13] = this.parseField(buffer, offset + 38, 1, 0);
            this.recordData[counter][14] = this.parseField(buffer, offset + 39, 1, 0);
            this.recordData[counter][15] = this.parseField(buffer, offset + 40, 2, 1);
            this.recordData[counter][16] = this.parseField(buffer, offset + 42, 2, 1);
            this.recordData[counter][17] = this.parseField(buffer, offset + 44, 1, 0);
            this.recordData[counter][18] = this.parseField(buffer, offset + 45, 1, 0);
            this.recordData[counter][19] = this.parseField(buffer, offset + 46, 2, 1);
        }
        return count;
    }

    private Object parseField(byte[] buffer, int startOffset, int length, int type) {
        Object value = null;
        switch (type) {
            case 0: {
                value = ConversionUtil.toShort(buffer, startOffset, length);
                break;
            }
            case 1: {
                value = ConversionUtil.toInt(buffer, startOffset, length);
                break;
            }
            case 2: {
                value = ConversionUtil.toLong(buffer, startOffset, length);
                break;
            }
            case 3: {
                value = ConversionUtil.toIPV4(buffer, startOffset, length);
                break;
            }
        }
        return value;
    }

    private boolean isValid(int length) {
        int minPacketSize = 24;
        return length >= 24 && length <= 65536;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public static String[] getHeaderFields() {
        return headerField;
    }

    public static String[] getRecordFields() {
        return recordField;
    }

    public Object[] getHeaderData() {
        return this.headerData;
    }

    public Object[][] getRecordData() {
        return this.recordData;
    }
}

