/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.git.client;

import java.util.Objects;

public class GitCreateContentRequest {
    private final String branch;
    private final String path;
    private final String content;
    private final String message;
    private final String existingContentSha;

    private GitCreateContentRequest(Builder builder) {
        this.branch = Objects.requireNonNull(builder.branch);
        this.path = Objects.requireNonNull(builder.path);
        this.content = Objects.requireNonNull(builder.content);
        this.message = Objects.requireNonNull(builder.message);
        this.existingContentSha = builder.existingContentSha;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getPath() {
        return this.path;
    }

    public String getContent() {
        return this.content;
    }

    public String getMessage() {
        return this.message;
    }

    public String getExistingContentSha() {
        return this.existingContentSha;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String branch;
        private String path;
        private String content;
        private String message;
        private String existingContentSha;

        public Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder existingContentSha(String existingSha) {
            this.existingContentSha = existingSha;
            return this;
        }

        public GitCreateContentRequest build() {
            return new GitCreateContentRequest(this);
        }
    }
}

