/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.nifi.action.FlowActionReporter;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.asset.AssetManager;
import org.apache.nifi.authentication.LoginIdentityProvider;
import org.apache.nifi.authorization.AccessPolicyProvider;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.UserGroupProvider;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.bundle.BundleDetails;
import org.apache.nifi.components.AsyncLoadedProcessor;
import org.apache.nifi.components.ClassloaderIsolationKeyProvider;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.StateProvider;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.leader.election.LeaderElectionManager;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.FlowFileSwapManager;
import org.apache.nifi.controller.status.analytics.StatusAnalyticsModel;
import org.apache.nifi.controller.status.history.StatusHistoryRepository;
import org.apache.nifi.flow.resource.ExternalResourceProvider;
import org.apache.nifi.flowanalysis.FlowAnalysisRule;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.init.ConfigurableComponentInitializer;
import org.apache.nifi.init.ConfigurableComponentInitializerFactory;
import org.apache.nifi.nar.ExtensionDefinition;
import org.apache.nifi.nar.ExtensionDiscoveringManager;
import org.apache.nifi.nar.InstanceClassLoader;
import org.apache.nifi.nar.NarClassLoader;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.nar.NarPersistenceProvider;
import org.apache.nifi.nar.PythonBundle;
import org.apache.nifi.nar.SharedInstanceClassLoader;
import org.apache.nifi.parameter.ParameterProvider;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.provenance.ProvenanceRepository;
import org.apache.nifi.python.PythonBridge;
import org.apache.nifi.python.PythonBundleCoordinate;
import org.apache.nifi.python.PythonProcessorDetails;
import org.apache.nifi.registry.flow.FlowRegistryClient;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardExtensionDiscoveringManager
implements ExtensionDiscoveringManager {
    private static final Logger logger = LoggerFactory.getLogger(StandardExtensionDiscoveringManager.class);
    private final Map<Class<?>, Set<ExtensionDefinition>> definitionMap = new HashMap();
    private final Map<String, List<Bundle>> classNameBundleLookup = new HashMap<String, List<Bundle>>();
    private final Map<BundleCoordinate, Set<ExtensionDefinition>> bundleCoordinateClassesLookup = new HashMap<BundleCoordinate, Set<ExtensionDefinition>>();
    private final Map<BundleCoordinate, Bundle> bundleCoordinateBundleLookup = new HashMap<BundleCoordinate, Bundle>();
    private final Map<ClassLoader, Bundle> classLoaderBundleLookup = new HashMap<ClassLoader, Bundle>();
    private final Map<String, ConfigurableComponent> tempComponentLookup = new HashMap<String, ConfigurableComponent>();
    private final Map<String, List<PythonProcessorDetails>> pythonProcessorDetails = new HashMap<String, List<PythonProcessorDetails>>();
    private final Map<String, InstanceClassLoader> instanceClassloaderLookup = new ConcurrentHashMap<String, InstanceClassLoader>();
    private final ConcurrentMap<BaseClassLoaderKey, SharedInstanceClassLoader> sharedBaseClassloaders = new ConcurrentHashMap<BaseClassLoaderKey, SharedInstanceClassLoader>();
    private PythonBridge pythonBridge;

    public StandardExtensionDiscoveringManager() {
        this(Collections.emptyList());
    }

    public StandardExtensionDiscoveringManager(Collection<Class<? extends ConfigurableComponent>> additionalExtensionTypes) {
        this.definitionMap.put(Processor.class, new HashSet());
        this.definitionMap.put(FlowFilePrioritizer.class, new HashSet());
        this.definitionMap.put(ReportingTask.class, new HashSet());
        this.definitionMap.put(FlowAnalysisRule.class, new HashSet());
        this.definitionMap.put(ParameterProvider.class, new HashSet());
        this.definitionMap.put(ControllerService.class, new HashSet());
        this.definitionMap.put(Authorizer.class, new HashSet());
        this.definitionMap.put(UserGroupProvider.class, new HashSet());
        this.definitionMap.put(AccessPolicyProvider.class, new HashSet());
        this.definitionMap.put(LoginIdentityProvider.class, new HashSet());
        this.definitionMap.put(ProvenanceRepository.class, new HashSet());
        this.definitionMap.put(StatusHistoryRepository.class, new HashSet());
        this.definitionMap.put(FlowFileRepository.class, new HashSet());
        this.definitionMap.put(FlowFileSwapManager.class, new HashSet());
        this.definitionMap.put(ContentRepository.class, new HashSet());
        this.definitionMap.put(StateProvider.class, new HashSet());
        this.definitionMap.put(StatusAnalyticsModel.class, new HashSet());
        this.definitionMap.put(ExternalResourceProvider.class, new HashSet());
        this.definitionMap.put(FlowRegistryClient.class, new HashSet());
        this.definitionMap.put(LeaderElectionManager.class, new HashSet());
        this.definitionMap.put(PythonBridge.class, new HashSet());
        this.definitionMap.put(NarPersistenceProvider.class, new HashSet());
        this.definitionMap.put(AssetManager.class, new HashSet());
        this.definitionMap.put(FlowActionReporter.class, new HashSet());
        additionalExtensionTypes.forEach(type -> this.definitionMap.putIfAbsent((Class<?>)type, new HashSet()));
    }

    @Override
    public synchronized Set<Bundle> getAllBundles() {
        return new HashSet<Bundle>(this.bundleCoordinateBundleLookup.values());
    }

    @Override
    public synchronized void discoverExtensions(Bundle systemBundle, Set<Bundle> narBundles) {
        this.loadExtensions(systemBundle, this.definitionMap.keySet());
        this.bundleCoordinateBundleLookup.put(systemBundle.getBundleDetails().getCoordinate(), systemBundle);
        this.discoverExtensions(narBundles);
    }

    @Override
    public synchronized void discoverExtensions(Set<Bundle> narBundles, boolean logDetails) {
        this.discoverExtensions(narBundles, this.definitionMap.keySet(), logDetails);
    }

    @Override
    public synchronized void discoverExtensions(Set<Bundle> narBundles, Set<Class<?>> extensionTypes, boolean logDetails) {
        ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
        for (Bundle bundle : narBundles) {
            ClassLoader ncl = bundle.getClassLoader();
            Thread.currentThread().setContextClassLoader(ncl);
            long loadStart = System.currentTimeMillis();
            this.loadExtensions(bundle, extensionTypes);
            long loadMillis = System.currentTimeMillis() - loadStart;
            if (logDetails) {
                logger.info("Loaded extensions for {} in {} millis", (Object)bundle.getBundleDetails(), (Object)loadMillis);
            }
            this.bundleCoordinateBundleLookup.put(bundle.getBundleDetails().getCoordinate(), bundle);
        }
        if (currentContextClassLoader != null) {
            Thread.currentThread().setContextClassLoader(currentContextClassLoader);
        }
    }

    @Override
    public synchronized void setPythonBridge(PythonBridge pythonBridge) {
        this.pythonBridge = pythonBridge;
    }

    @Override
    public synchronized void discoverPythonExtensions(Bundle pythonBundle) {
        this.discoverPythonExtensions(pythonBundle, true);
    }

    @Override
    public synchronized void discoverNewPythonExtensions(Bundle pythonBundle) {
        logger.debug("Scanning to discover new Python extensions...");
        this.discoverPythonExtensions(pythonBundle, false);
    }

    @Override
    public synchronized void discoverPythonExtensions(Bundle pythonBundle, Set<Bundle> bundles) {
        logger.debug("Scanning to discover which Python extensions are available and importing any necessary dependencies. If new components are discovered, this may take a few minutes. See python logs for more details.");
        long start = System.currentTimeMillis();
        List<File> bundleWorkingDirectories = bundles.stream().map(Bundle::getBundleDetails).map(BundleDetails::getWorkingDirectory).toList();
        this.pythonBridge.discoverExtensions(bundleWorkingDirectories);
        this.loadPythonExtensions(pythonBundle, start);
    }

    private void discoverPythonExtensions(Bundle pythonBundle, boolean includeNarBundles) {
        logger.debug("Scanning to discover which Python extensions are available and importing any necessary dependencies. If new components are discovered, this may take a few minutes. See python logs for more details.");
        long start = System.currentTimeMillis();
        this.pythonBridge.discoverExtensions(includeNarBundles);
        this.loadPythonExtensions(pythonBundle, start);
    }

    private void loadPythonExtensions(Bundle pythonBundle, long startTime) {
        this.bundleCoordinateBundleLookup.putIfAbsent(pythonBundle.getBundleDetails().getCoordinate(), pythonBundle);
        Set<ExtensionDefinition> processorDefinitions = this.definitionMap.get(Processor.class);
        List pythonProcessorDetails = this.pythonBridge.getProcessorTypes();
        int processorsFound = 0;
        for (PythonProcessorDetails details : pythonProcessorDetails) {
            BundleDetails bundleDetails = this.createBundleDetailsWithOverriddenVersion(pythonBundle.getBundleDetails(), details.getProcessorVersion());
            Bundle bundle = new Bundle(bundleDetails, pythonBundle.getClassLoader());
            String className = details.getProcessorType();
            ExtensionDefinition extensionDefinition = new ExtensionDefinition.Builder().implementationClassName(className).runtime(ExtensionDefinition.ExtensionRuntime.PYTHON).bundle(bundle).extensionType(Processor.class).description(details.getCapabilityDescription()).tags(details.getTags()).version(details.getProcessorVersion()).build();
            boolean added = processorDefinitions.add(extensionDefinition);
            if (added) {
                ++processorsFound;
                List bundlesForClass = this.classNameBundleLookup.computeIfAbsent(className, key -> new ArrayList());
                bundlesForClass.add(bundle);
                this.bundleCoordinateBundleLookup.putIfAbsent(bundleDetails.getCoordinate(), bundle);
                Set bundleExtensionDefinitions = this.bundleCoordinateClassesLookup.computeIfAbsent(bundleDetails.getCoordinate(), key -> new HashSet());
                bundleExtensionDefinitions.add(extensionDefinition);
                List detailsList = this.pythonProcessorDetails.computeIfAbsent(details.getProcessorType(), key -> new ArrayList());
                detailsList.add(details);
                logger.info("Discovered Python Processor {}", (Object)details.getProcessorType());
                continue;
            }
            logger.debug("Python Processor {} is already known", (Object)details.getProcessorType());
        }
        if (processorsFound == 0) {
            logger.debug("Discovered no new or updated Python Processors. Process took in {} millis", (Object)(System.currentTimeMillis() - startTime));
        } else {
            logger.info("Discovered or updated {} Python Processors in {} millis", (Object)processorsFound, (Object)(System.currentTimeMillis() - startTime));
        }
    }

    @Override
    public synchronized PythonProcessorDetails getPythonProcessorDetails(String processorType, String version) {
        List<PythonProcessorDetails> detailsList = this.pythonProcessorDetails.get(processorType);
        if (detailsList == null) {
            return null;
        }
        for (PythonProcessorDetails processorDetails : detailsList) {
            if (!processorDetails.getProcessorVersion().equals(version)) continue;
            return processorDetails;
        }
        return null;
    }

    @Override
    public synchronized Set<ExtensionDefinition> getPythonExtensions(BundleCoordinate originalBundleCoordinate) {
        HashSet<ExtensionDefinition> pythonProcessorDefinitions = new HashSet<ExtensionDefinition>();
        for (ExtensionDefinition processorDefinition : this.definitionMap.get(Processor.class)) {
            PythonProcessorDetails processorDetails = this.getPythonProcessorDetails(processorDefinition.getImplementationClassName(), processorDefinition.getVersion());
            if (processorDetails == null) continue;
            PythonBundleCoordinate pythonBundleCoordinate = processorDetails.getBundleCoordinate();
            if (!originalBundleCoordinate.getGroup().equals(pythonBundleCoordinate.getGroup()) || !originalBundleCoordinate.getId().equals(pythonBundleCoordinate.getId()) || !originalBundleCoordinate.getVersion().equals(pythonBundleCoordinate.getVersion())) continue;
            pythonProcessorDefinitions.add(processorDefinition);
        }
        logger.trace("Found {} Python Processor definitions loaded from [{}]", (Object)pythonProcessorDefinitions.size(), (Object)originalBundleCoordinate);
        return pythonProcessorDefinitions;
    }

    private BundleDetails createBundleDetailsWithOverriddenVersion(BundleDetails details, String version) {
        BundleCoordinate overriddenCoordinate = new BundleCoordinate(details.getCoordinate().getGroup(), details.getCoordinate().getId(), version);
        return new BundleDetails.Builder().buildBranch(details.getBuildBranch()).buildJdk(details.getBuildJdk()).buildRevision(details.getBuildRevision()).buildTag(details.getBuildTag()).buildTimestamp(details.getBuildTimestamp()).builtBy(details.getBuiltBy()).dependencyCoordinate(details.getDependencyCoordinate()).coordinate(overriddenCoordinate).workingDir(details.getWorkingDirectory()).build();
    }

    private void loadExtensions(Bundle bundle, Set<Class<?>> extensionTypes) {
        for (Class<?> extensionType : extensionTypes) {
            String serviceType = extensionType.getName();
            try {
                Set<URL> serviceResourceUrls = this.getServiceFileURLs(bundle, extensionType);
                logger.debug("Bundle {} has the following Services File URLs for {}: {}", new Object[]{bundle, serviceType, serviceResourceUrls});
                for (URL serviceResourceUrl : serviceResourceUrls) {
                    Set<String> implementationClassNames = this.getServiceFileImplementationClassNames(serviceResourceUrl);
                    logger.debug("Bundle {} defines {} implementations of interface {}", new Object[]{bundle, implementationClassNames.size(), serviceType});
                    for (String implementationClassName : implementationClassNames) {
                        try {
                            this.loadExtension(implementationClassName, extensionType, bundle);
                            logger.debug("Successfully loaded {} {} from {}", new Object[]{extensionType.getSimpleName(), implementationClassName, bundle});
                        }
                        catch (Exception e) {
                            logger.error("Failed to register {} of type {} in bundle {}", new Object[]{extensionType.getSimpleName(), implementationClassName, bundle, e});
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to get resources of type " + serviceType + " from bundle " + String.valueOf(bundle));
            }
        }
        this.classLoaderBundleLookup.put(bundle.getClassLoader(), bundle);
    }

    private Set<String> getServiceFileImplementationClassNames(URL serviceFileUrl) throws IOException {
        HashSet<String> implementationClassNames = new HashSet<String>();
        try (InputStream in = serviceFileUrl.openStream();
             InputStreamReader inputStreamReader = new InputStreamReader(in);
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                int index = line.indexOf("#");
                if (index >= 0) {
                    line = line.substring(0, index);
                }
                if ((line = line.trim()).isEmpty()) continue;
                implementationClassNames.add(line);
            }
        }
        return implementationClassNames;
    }

    private Set<URL> getServiceFileURLs(Bundle bundle, Class<?> extensionType) throws IOException {
        String servicesFile = "META-INF/services/" + extensionType.getName();
        Enumeration<URL> serviceResourceUrlEnum = bundle.getClassLoader().getResources(servicesFile);
        HashSet<URL> serviceResourceUrls = new HashSet<URL>();
        while (serviceResourceUrlEnum.hasMoreElements()) {
            serviceResourceUrls.add(serviceResourceUrlEnum.nextElement());
        }
        Enumeration<URL> parentResourceUrlEnum = bundle.getClassLoader().getParent().getResources(servicesFile);
        while (parentResourceUrlEnum.hasMoreElements()) {
            serviceResourceUrls.remove(parentResourceUrlEnum.nextElement());
        }
        return serviceResourceUrls;
    }

    protected void loadExtension(String extensionClassName, Class<?> extensionType, Bundle bundle) {
        this.registerExtensionClass(extensionType, extensionClassName, bundle);
    }

    protected void registerExtensionClass(Class<?> extensionType, String implementationClassName, Bundle bundle) {
        Set<ExtensionDefinition> registeredClasses = this.definitionMap.get(extensionType);
        this.registerServiceClass(implementationClassName, extensionType, this.classNameBundleLookup, this.bundleCoordinateClassesLookup, bundle, registeredClasses);
    }

    protected void initializeTempComponent(ConfigurableComponent configurableComponent) {
        try {
            ConfigurableComponentInitializer initializer = ConfigurableComponentInitializerFactory.createComponentInitializer(this, configurableComponent.getClass());
            if (initializer != null) {
                initializer.initialize(configurableComponent);
            }
        }
        catch (InitializationException e) {
            logger.warn("Unable to initialize component {} due to {}", (Object)configurableComponent.getClass().getName(), (Object)e.getMessage());
        }
    }

    private void registerServiceClass(String className, Class<?> extensionType, Map<String, List<Bundle>> classNameBundleMap, Map<BundleCoordinate, Set<ExtensionDefinition>> bundleCoordinateClassesMap, Bundle bundle, Set<ExtensionDefinition> classes) {
        BundleCoordinate bundleCoordinate = bundle.getBundleDetails().getCoordinate();
        List registeredBundles = classNameBundleMap.computeIfAbsent(className, key -> new ArrayList());
        Set bundleExtensionDefinitions = bundleCoordinateClassesMap.computeIfAbsent(bundleCoordinate, key -> new HashSet());
        boolean alreadyRegistered = false;
        for (Bundle registeredBundle : registeredBundles) {
            BundleCoordinate registeredCoordinate = registeredBundle.getBundleDetails().getCoordinate();
            if (registeredCoordinate.equals((Object)bundleCoordinate)) {
                alreadyRegistered = true;
                break;
            }
            if (StandardExtensionDiscoveringManager.multipleVersionsAllowed(extensionType)) continue;
            logger.debug("Attempt was made to load {} from {} but that class name is already loaded/registered from {} and multiple versions are not supported for this type", new Object[]{className, bundle.getBundleDetails().getCoordinate().getCoordinate(), registeredBundle.getBundleDetails().getCoordinate()});
            return;
        }
        if (!alreadyRegistered) {
            registeredBundles.add(bundle);
            ExtensionDefinition extensionDefinition = new ExtensionDefinition.Builder().implementationClassName(className).bundle(bundle).extensionType(extensionType).runtime(ExtensionDefinition.ExtensionRuntime.JAVA).build();
            bundleExtensionDefinitions.add(extensionDefinition);
            classes.add(extensionDefinition);
        }
    }

    @Override
    public Class<?> getClass(ExtensionDefinition extensionDefinition) {
        Bundle bundle = extensionDefinition.getBundle();
        ClassLoader bundleClassLoader = bundle.getClassLoader();
        NarCloseable ignored = NarCloseable.withComponentNarLoader(bundleClassLoader);
        try {
            Class<?> clazz = Class.forName(extensionDefinition.getImplementationClassName(), true, bundleClassLoader);
            if (ignored != null) {
                ignored.close();
            }
            return clazz;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create Class for " + String.valueOf(extensionDefinition), e);
            }
        }
    }

    private static boolean multipleVersionsAllowed(Class<?> type) {
        return Processor.class.isAssignableFrom(type) || ControllerService.class.isAssignableFrom(type) || ReportingTask.class.isAssignableFrom(type) || FlowAnalysisRule.class.isAssignableFrom(type) || ParameterProvider.class.isAssignableFrom(type) || FlowRegistryClient.class.isAssignableFrom(type);
    }

    protected boolean isInstanceClassLoaderRequired(String classType, Bundle bundle) {
        ClassLoader bundleClassLoader = bundle.getClassLoader();
        if (!(bundleClassLoader instanceof NarClassLoader)) {
            return false;
        }
        ConfigurableComponent tempComponent = this.getTempComponent(classType, bundle.getBundleDetails().getCoordinate());
        if (tempComponent == null) {
            return false;
        }
        return tempComponent.getClass().isAnnotationPresent(RequiresInstanceClassLoading.class);
    }

    @Override
    public synchronized InstanceClassLoader createInstanceClassLoader(String classType, String instanceIdentifier, Bundle bundle, Set<URL> additionalUrls, boolean register, String classloaderIsolationKey) {
        InstanceClassLoader instanceClassLoader;
        if (StringUtils.isEmpty((String)classType)) {
            throw new IllegalArgumentException("Class-Type is required");
        }
        if (StringUtils.isEmpty((String)instanceIdentifier)) {
            throw new IllegalArgumentException("Instance Identifier is required");
        }
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle is required");
        }
        ClassLoader bundleClassLoader = bundle.getClassLoader();
        boolean requiresInstanceClassLoader = this.isInstanceClassLoaderRequired(classType, bundle);
        if (requiresInstanceClassLoader) {
            ConfigurableComponent tempComponent = this.getTempComponent(classType, bundle.getBundleDetails().getCoordinate());
            Class type = tempComponent.getClass();
            boolean allowsSharedClassloader = tempComponent instanceof ClassloaderIsolationKeyProvider;
            if (allowsSharedClassloader && classloaderIsolationKey == null) {
                instanceClassLoader = new InstanceClassLoader(instanceIdentifier, classType, Collections.emptySet(), additionalUrls, bundleClassLoader);
            } else {
                BaseClassLoaderKey baseClassLoaderKey = classloaderIsolationKey == null ? null : new BaseClassLoaderKey(bundle, classloaderIsolationKey);
                NarClassLoader narBundleClassLoader = (NarClassLoader)bundleClassLoader;
                logger.debug("Including ClassLoader resources from {} for component {}", (Object)bundle.getBundleDetails(), (Object)instanceIdentifier);
                LinkedHashSet<URL> instanceUrls = new LinkedHashSet<URL>(Arrays.asList(narBundleClassLoader.getURLs()));
                LinkedHashSet<File> narNativeLibDirs = new LinkedHashSet<File>();
                narNativeLibDirs.add(narBundleClassLoader.getNARNativeLibDir());
                Object ancestorClassLoader = narBundleClassLoader.getParent();
                boolean resolvedSharedClassLoader = false;
                RequiresInstanceClassLoading requiresInstanceClassLoading = type.getAnnotation(RequiresInstanceClassLoading.class);
                if (requiresInstanceClassLoading.cloneAncestorResources()) {
                    SharedInstanceClassLoader sharedBaseClassloader;
                    if (baseClassLoaderKey != null && (sharedBaseClassloader = (SharedInstanceClassLoader)((Object)this.sharedBaseClassloaders.get(baseClassLoaderKey))) != null && sharedBaseClassloader.incrementReferenceCount()) {
                        resolvedSharedClassLoader = true;
                        ancestorClassLoader = sharedBaseClassloader;
                        logger.debug("Creating InstanceClassLoader for type {} using shared Base ClassLoader {} for component {}", new Object[]{type, sharedBaseClassloader, instanceIdentifier});
                    }
                    if (!resolvedSharedClassLoader) {
                        Bundle ancestorNarBundle;
                        ConfigurableComponent component = this.getTempComponent(classType, bundle.getBundleDetails().getCoordinate());
                        Set<BundleCoordinate> reachableApiBundles = this.findReachableApiBundles(component);
                        while (ancestorClassLoader instanceof NarClassLoader && (ancestorNarBundle = this.classLoaderBundleLookup.get(ancestorClassLoader)) != null && !reachableApiBundles.contains(ancestorNarBundle.getBundleDetails().getCoordinate()) && !ancestorNarBundle.getBundleDetails().getCoordinate().getId().equals("nifi-jetty-nar")) {
                            NarClassLoader ancestorNarClassLoader = (NarClassLoader)ancestorClassLoader;
                            narNativeLibDirs.add(ancestorNarClassLoader.getNARNativeLibDir());
                            Collections.addAll(instanceUrls, ancestorNarClassLoader.getURLs());
                            ancestorClassLoader = ancestorNarClassLoader.getParent();
                        }
                    }
                }
                if (baseClassLoaderKey != null && !resolvedSharedClassLoader) {
                    SharedInstanceClassLoader sharedClassLoader = new SharedInstanceClassLoader(instanceIdentifier, classType, (Set<URL>)instanceUrls, Collections.emptySet(), (Set<File>)narNativeLibDirs, (ClassLoader)ancestorClassLoader);
                    sharedClassLoader.incrementReferenceCount();
                    instanceClassLoader = new InstanceClassLoader(instanceIdentifier, classType, Collections.emptySet(), additionalUrls, Collections.emptySet(), (ClassLoader)((Object)sharedClassLoader));
                    logger.debug("Creating InstanceClassLoader for type {} using newly created shared Base ClassLoader {} for component {}", new Object[]{type, sharedClassLoader, instanceIdentifier});
                    if (logger.isTraceEnabled()) {
                        for (URL url : sharedClassLoader.getURLs()) {
                            logger.trace("Shared Base ClassLoader URL resource: {}", (Object)url.toExternalForm());
                        }
                    }
                    this.sharedBaseClassloaders.putIfAbsent(baseClassLoaderKey, sharedClassLoader);
                } else {
                    Set<URL> resolvedInstanceUrls = resolvedSharedClassLoader ? Collections.emptySet() : instanceUrls;
                    instanceClassLoader = new InstanceClassLoader(instanceIdentifier, classType, resolvedInstanceUrls, additionalUrls, (Set<File>)narNativeLibDirs, (ClassLoader)ancestorClassLoader);
                }
            }
        } else {
            instanceClassLoader = new InstanceClassLoader(instanceIdentifier, classType, Collections.emptySet(), additionalUrls, bundleClassLoader);
        }
        if (logger.isTraceEnabled()) {
            for (URL url : instanceClassLoader.getURLs()) {
                logger.trace("URL resource {} for {}...", (Object)url.toExternalForm(), (Object)instanceIdentifier);
            }
        }
        if (register) {
            this.instanceClassloaderLookup.put(instanceIdentifier, instanceClassLoader);
        }
        return instanceClassLoader;
    }

    protected Set<BundleCoordinate> findReachableApiBundles(ConfigurableComponent component) {
        HashSet<BundleCoordinate> reachableApiBundles = new HashSet<BundleCoordinate>();
        try (NarCloseable ignored = NarCloseable.withComponentNarLoader(component.getClass().getClassLoader());){
            List descriptors = component.getPropertyDescriptors();
            if (descriptors != null && !descriptors.isEmpty()) {
                for (PropertyDescriptor descriptor : descriptors) {
                    Class serviceApi = descriptor.getControllerServiceDefinition();
                    if (serviceApi == null || component.getClass().getClassLoader().equals(serviceApi.getClassLoader())) continue;
                    Bundle apiBundle = this.classLoaderBundleLookup.get(serviceApi.getClassLoader());
                    reachableApiBundles.add(apiBundle.getBundleDetails().getCoordinate());
                }
            }
        }
        return reachableApiBundles;
    }

    @Override
    public synchronized InstanceClassLoader getInstanceClassLoader(String instanceIdentifier) {
        return this.instanceClassloaderLookup.get(instanceIdentifier);
    }

    @Override
    public synchronized InstanceClassLoader removeInstanceClassLoader(String instanceIdentifier) {
        if (instanceIdentifier == null) {
            return null;
        }
        InstanceClassLoader classLoader = this.instanceClassloaderLookup.remove(instanceIdentifier);
        this.closeURLClassLoader(instanceIdentifier, (ClassLoader)((Object)classLoader));
        return classLoader;
    }

    @Override
    public synchronized void registerInstanceClassLoader(String instanceIdentifier, InstanceClassLoader instanceClassLoader) {
        this.instanceClassloaderLookup.putIfAbsent(instanceIdentifier, instanceClassLoader);
    }

    @Override
    public void closeURLClassLoader(String instanceIdentifier, ClassLoader classLoader) {
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            try {
                urlClassLoader.close();
            }
            catch (IOException e) {
                logger.warn("Unable to close URLClassLoader for {}", (Object)instanceIdentifier);
            }
        }
    }

    @Override
    public synchronized List<Bundle> getBundles(String classType) {
        if (classType == null) {
            throw new IllegalArgumentException("Class type cannot be null");
        }
        List<Bundle> bundles = this.classNameBundleLookup.get(classType);
        return bundles == null ? Collections.emptyList() : new ArrayList<Bundle>(bundles);
    }

    @Override
    public synchronized Bundle getBundle(BundleCoordinate bundleCoordinate) {
        if (bundleCoordinate == null) {
            throw new IllegalArgumentException("BundleCoordinate cannot be null");
        }
        return this.bundleCoordinateBundleLookup.get(bundleCoordinate);
    }

    @Override
    public synchronized Set<Bundle> removeBundles(Collection<BundleCoordinate> bundleCoordinates) {
        LinkedHashSet<Bundle> removedBundles = new LinkedHashSet<Bundle>();
        for (BundleCoordinate bundleCoordinate : bundleCoordinates) {
            Bundle removedBundle = this.removeBundle(bundleCoordinate);
            if (removedBundle == null) continue;
            removedBundles.add(removedBundle);
        }
        return removedBundles;
    }

    private Bundle removeBundle(BundleCoordinate bundleCoordinate) {
        if (PythonBundle.isPythonCoordinate((BundleCoordinate)bundleCoordinate)) {
            throw new IllegalStateException("Python bundle [%s] cannot be removed".formatted(bundleCoordinate));
        }
        Bundle removedBundle = this.bundleCoordinateBundleLookup.remove(bundleCoordinate);
        if (removedBundle == null) {
            logger.debug("Bundle not found with coordinate [{}]", (Object)bundleCoordinate);
            return null;
        }
        logger.debug("Removing bundle [{}]", (Object)bundleCoordinate);
        ClassLoader removedBundleClassLoader = removedBundle.getClassLoader();
        this.classLoaderBundleLookup.remove(removedBundleClassLoader);
        if (removedBundleClassLoader instanceof URLClassLoader) {
            try {
                ((URLClassLoader)removedBundleClassLoader).close();
            }
            catch (IOException e) {
                logger.warn("Failed to close ClassLoader for {}", (Object)bundleCoordinate, (Object)e);
            }
        }
        HashSet<ExtensionDefinition> extensionDefinitions = new HashSet<ExtensionDefinition>();
        extensionDefinitions.addAll(Optional.ofNullable(this.bundleCoordinateClassesLookup.remove(bundleCoordinate)).orElse(Collections.emptySet()));
        extensionDefinitions.addAll(this.getPythonExtensions(bundleCoordinate));
        extensionDefinitions.forEach(this::removeExtensionDefinition);
        return removedBundle;
    }

    private void removeExtensionDefinition(ExtensionDefinition extensionDefinition) {
        BundleCoordinate extensionDefinitionCoordinate = extensionDefinition.getBundle().getBundleDetails().getCoordinate();
        logger.debug("Removing extension definition [{}] from [{}]", (Object)extensionDefinition.getImplementationClassName(), (Object)extensionDefinitionCoordinate);
        Set<ExtensionDefinition> definitions = this.definitionMap.get(extensionDefinition.getExtensionType());
        if (definitions != null) {
            definitions.remove(extensionDefinition);
        }
        String removeExtensionClassName = extensionDefinition.getImplementationClassName();
        List classNameBundles = Optional.ofNullable(this.classNameBundleLookup.get(removeExtensionClassName)).orElse(Collections.emptyList());
        classNameBundles.removeIf(bundle -> bundle.getBundleDetails().getCoordinate().equals((Object)extensionDefinitionCoordinate));
        String tempComponentKey = StandardExtensionDiscoveringManager.getClassBundleKey(removeExtensionClassName, extensionDefinitionCoordinate);
        ConfigurableComponent removedTempComponent = this.tempComponentLookup.remove(tempComponentKey);
        if (PythonBundle.isPythonCoordinate((BundleCoordinate)extensionDefinitionCoordinate)) {
            logger.debug("Removing Python processor type {} - {}", (Object)removeExtensionClassName, (Object)extensionDefinition.getVersion());
            List processorDetailsList = Optional.ofNullable(this.pythonProcessorDetails.get(removeExtensionClassName)).orElse(Collections.emptyList());
            processorDetailsList.removeIf(processorDetails -> processorDetails.getProcessorType().equals(removeExtensionClassName) && processorDetails.getProcessorVersion().equals(extensionDefinition.getVersion()));
            if (removedTempComponent != null) {
                String pythonTempComponentId = StandardExtensionDiscoveringManager.getPythonTempComponentId(removeExtensionClassName);
                this.pythonBridge.onProcessorRemoved(pythonTempComponentId, removeExtensionClassName, extensionDefinition.getVersion());
            }
            this.pythonBridge.removeProcessorType(removeExtensionClassName, extensionDefinition.getVersion());
        }
    }

    @Override
    public synchronized Set<Bundle> getDependentBundles(BundleCoordinate bundleCoordinate) {
        return this.getAllBundles().stream().filter(bundle -> bundle.getBundleDetails().getDependencyCoordinate() != null && bundle.getBundleDetails().getDependencyCoordinate().equals((Object)bundleCoordinate)).collect(Collectors.toSet());
    }

    @Override
    public synchronized Set<ExtensionDefinition> getTypes(BundleCoordinate bundleCoordinate) {
        if (bundleCoordinate == null) {
            throw new IllegalArgumentException("BundleCoordinate cannot be null");
        }
        Set<ExtensionDefinition> types = this.bundleCoordinateClassesLookup.get(bundleCoordinate);
        return types == null ? Collections.emptySet() : Collections.unmodifiableSet(types);
    }

    @Override
    public synchronized Bundle getBundle(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("ClassLoader cannot be null");
        }
        return this.classLoaderBundleLookup.get(classLoader);
    }

    @Override
    public synchronized Set<ExtensionDefinition> getExtensions(Class<?> definition) {
        if (definition == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        Set<ExtensionDefinition> extensions = this.definitionMap.get(definition);
        return extensions == null ? Collections.emptySet() : new HashSet<ExtensionDefinition>(extensions);
    }

    @Override
    public synchronized ConfigurableComponent getTempComponent(String classType, BundleCoordinate bundleCoordinate) {
        if (classType == null) {
            throw new IllegalArgumentException("Class type cannot be null");
        }
        if (bundleCoordinate == null) {
            throw new IllegalArgumentException("Bundle Coordinate cannot be null");
        }
        String bundleKey = StandardExtensionDiscoveringManager.getClassBundleKey(classType, bundleCoordinate);
        ConfigurableComponent existing = this.tempComponentLookup.get(bundleKey);
        if (existing != null) {
            return existing;
        }
        Bundle bundle = this.getBundle(bundleCoordinate);
        if (bundle == null) {
            logger.error("Could not instantiate class of type {} using ClassLoader for bundle {} because the bundle could not be found", (Object)classType, (Object)bundleCoordinate);
            return null;
        }
        ClassLoader bundleClassLoader = bundle.getClassLoader();
        NarCloseable ignored = NarCloseable.withComponentNarLoader(bundleClassLoader);
        try {
            AsyncLoadedProcessor componentClass;
            AsyncLoadedProcessor tempComponent;
            if (PythonBundle.isPythonCoordinate((BundleCoordinate)bundle.getBundleDetails().getCoordinate())) {
                String procId = StandardExtensionDiscoveringManager.getPythonTempComponentId(classType);
                tempComponent = this.pythonBridge.createProcessor(procId, classType, bundleCoordinate.getVersion(), false, false);
            } else {
                componentClass = Class.forName(classType, true, bundleClassLoader);
                tempComponent = (ConfigurableComponent)componentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            this.initializeTempComponent((ConfigurableComponent)tempComponent);
            this.tempComponentLookup.put(bundleKey, (ConfigurableComponent)tempComponent);
            componentClass = tempComponent;
            if (ignored != null) {
                ignored.close();
            }
            return componentClass;
        }
        catch (Throwable tempComponent) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable componentClass) {
                        tempComponent.addSuppressed(componentClass);
                    }
                }
                throw tempComponent;
            }
            catch (Exception e) {
                logger.error("Could not instantiate class of type {} using ClassLoader for bundle {}", new Object[]{classType, bundleCoordinate, e});
                if (logger.isDebugEnabled() && bundleClassLoader instanceof URLClassLoader) {
                    URLClassLoader urlClassLoader = (URLClassLoader)bundleClassLoader;
                    List<URL> availableUrls = Arrays.asList(urlClassLoader.getURLs());
                    logger.debug("Available URLs for Bundle ClassLoader {}: {}", (Object)bundleCoordinate, availableUrls);
                }
                return null;
            }
        }
    }

    private static String getPythonTempComponentId(String type) {
        return "temp-component-" + type;
    }

    private static String getClassBundleKey(String classType, BundleCoordinate bundleCoordinate) {
        return classType + "_" + bundleCoordinate.getCoordinate();
    }

    @Override
    public synchronized void logClassLoaderMapping() {
        StringBuilder builder = new StringBuilder();
        builder.append("Extension Type Mapping to Bundle:");
        for (Map.Entry<Class<?>, Set<ExtensionDefinition>> entry : this.definitionMap.entrySet()) {
            builder.append("\n\t=== ").append(entry.getKey().getSimpleName()).append(" Type ===");
            for (ExtensionDefinition extensionDefinition : entry.getValue()) {
                String implementationClassName = extensionDefinition.getImplementationClassName();
                List bundles = this.classNameBundleLookup.getOrDefault(implementationClassName, Collections.emptyList());
                builder.append("\n\t").append(implementationClassName);
                for (Bundle bundle : bundles) {
                    String coordinate = bundle.getBundleDetails().getCoordinate().getCoordinate();
                    String workingDir = bundle.getBundleDetails().getWorkingDirectory().getPath();
                    builder.append("\n\t\t").append(coordinate).append(" || ").append(workingDir);
                }
            }
            builder.append("\n\t=== End ").append(entry.getKey().getSimpleName()).append(" types ===");
        }
        logger.info("{}", (Object)builder);
    }

    @Override
    public synchronized void logClassLoaderDetails() {
        if (!logger.isDebugEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("ClassLoader Hierarchy:\n");
        for (Bundle bundle : this.classLoaderBundleLookup.values()) {
            this.buildClassLoaderDetails(bundle, sb, 0);
            sb.append("\n---------------------------------------------------------------------------------------------------------\n");
        }
        String message = sb.toString();
        logger.debug(message);
    }

    private void buildClassLoaderDetails(Bundle bundle, StringBuilder sb, int indentLevel) {
        Bundle parent;
        BundleCoordinate parentCoordinate;
        StringBuilder indentBuilder = new StringBuilder();
        indentBuilder.append("\n");
        for (int i = 0; i < indentLevel; ++i) {
            indentBuilder.append(" ");
        }
        String prefix = indentBuilder.toString();
        sb.append(prefix).append("Bundle: ").append(bundle);
        sb.append(prefix).append("Working Directory: ").append(bundle.getBundleDetails().getWorkingDirectory().getAbsolutePath());
        sb.append(prefix).append("Coordinates: ").append(bundle.getBundleDetails().getCoordinate().getCoordinate());
        sb.append(prefix).append("Files loaded: ").append(bundle.getBundleDetails().getCoordinate().getCoordinate());
        ClassLoader classLoader = bundle.getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            URL[] urls;
            for (URL url : urls = ((URLClassLoader)bundle.getClassLoader()).getURLs()) {
                sb.append(prefix).append("    ").append(url.getFile());
            }
        }
        if ((parentCoordinate = bundle.getBundleDetails().getDependencyCoordinate()) != null && (parent = this.getBundle(parentCoordinate)) != null) {
            this.buildClassLoaderDetails(parent, sb, indentLevel + 4);
        }
    }

    private static class BaseClassLoaderKey {
        private final Bundle bundle;
        private final String classloaderIsolationKey;

        public BaseClassLoaderKey(Bundle bundle, String classloaderIsolationKey) {
            this.bundle = Objects.requireNonNull(bundle);
            this.classloaderIsolationKey = Objects.requireNonNull(classloaderIsolationKey);
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseClassLoaderKey that = (BaseClassLoaderKey)o;
            return this.bundle.equals((Object)that.bundle) && this.classloaderIsolationKey.equals(that.classloaderIsolationKey);
        }

        public int hashCode() {
            return Objects.hash(this.bundle, this.classloaderIsolationKey);
        }
    }
}

