/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.annotation.notification.OnPrimaryNodeStateChange;
import org.apache.nifi.annotation.notification.PrimaryNodeState;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.validation.ValidationState;
import org.apache.nifi.components.validation.ValidationStatus;
import org.apache.nifi.components.validation.ValidationTrigger;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractComponentNode;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.LoggableComponent;
import org.apache.nifi.controller.ReloadComponent;
import org.apache.nifi.controller.TerminationAwareLogger;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.VerifiableControllerService;
import org.apache.nifi.controller.exception.ControllerServiceInstantiationException;
import org.apache.nifi.controller.service.ControllerServiceDetails;
import org.apache.nifi.controller.service.ControllerServiceInvocationHandler;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.ControllerServiceReference;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.controller.service.ServiceStateTransition;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.controller.service.StandardControllerServiceReference;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.GroupedComponent;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.apache.nifi.logging.LoggingContext;
import org.apache.nifi.logging.StandardLoggingContext;
import org.apache.nifi.migration.ControllerServiceCreationDetails;
import org.apache.nifi.migration.ControllerServiceFactory;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.migration.StandardPropertyConfiguration;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.InstanceClassLoader;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.util.CharacterFilterUtils;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.ReflectionUtils;
import org.apache.nifi.util.Tuple;
import org.apache.nifi.util.file.classloader.ClassLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardControllerServiceNode
extends AbstractComponentNode
implements ControllerServiceNode {
    private static final Logger LOG = LoggerFactory.getLogger(StandardControllerServiceNode.class);
    private static final long INCREMENTAL_VALIDATION_DELAY_MS = 1000L;
    private static final Duration MAXIMUM_DELAY = Duration.ofMinutes(10L);
    private final AtomicReference<ControllerServiceDetails> controllerServiceHolder = new AtomicReference<Object>(null);
    private final ControllerServiceProvider serviceProvider;
    private final ServiceStateTransition stateTransition;
    private final AtomicReference<String> versionedComponentId = new AtomicReference();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private final Set<Tuple<ComponentNode, PropertyDescriptor>> referencingComponents = new HashSet<Tuple<ComponentNode, PropertyDescriptor>>();
    private volatile String comment;
    private volatile ProcessGroup processGroup;
    private volatile LogLevel bulletinLevel = LogLevel.WARN;
    private final AtomicBoolean active;

    public StandardControllerServiceNode(LoggableComponent<ControllerService> implementation, LoggableComponent<ControllerService> proxiedControllerService, ControllerServiceInvocationHandler invocationHandler, String id, ValidationContextFactory validationContextFactory, ControllerServiceProvider serviceProvider, ReloadComponent reloadComponent, ExtensionManager extensionManager, ValidationTrigger validationTrigger) {
        this(implementation, proxiedControllerService, invocationHandler, id, validationContextFactory, serviceProvider, ((ControllerService)implementation.getComponent()).getClass().getSimpleName(), ((ControllerService)implementation.getComponent()).getClass().getCanonicalName(), reloadComponent, extensionManager, validationTrigger, false);
    }

    public StandardControllerServiceNode(LoggableComponent<ControllerService> implementation, LoggableComponent<ControllerService> proxiedControllerService, ControllerServiceInvocationHandler invocationHandler, String id, ValidationContextFactory validationContextFactory, ControllerServiceProvider serviceProvider, String componentType, String componentCanonicalClass, ReloadComponent reloadComponent, ExtensionManager extensionManager, ValidationTrigger validationTrigger, boolean isExtensionMissing) {
        super(id, validationContextFactory, serviceProvider, componentType, componentCanonicalClass, reloadComponent, extensionManager, validationTrigger, isExtensionMissing);
        this.serviceProvider = serviceProvider;
        this.active = new AtomicBoolean();
        this.setControllerServiceAndProxy(implementation, proxiedControllerService, invocationHandler);
        this.stateTransition = new ServiceStateTransition(this);
        this.comment = "";
    }

    public ConfigurableComponent getComponent() {
        return this.controllerServiceHolder.get().getImplementation();
    }

    public TerminationAwareLogger getLogger() {
        return this.controllerServiceHolder.get().getComponentLog();
    }

    public BundleCoordinate getBundleCoordinate() {
        return this.controllerServiceHolder.get().getBundleCoordinate();
    }

    public Authorizable getParentAuthorizable() {
        ProcessGroup processGroup = this.getProcessGroup();
        if (processGroup == null) {
            return new Authorizable(this){

                public Authorizable getParentAuthorizable() {
                    return null;
                }

                public Resource getResource() {
                    return ResourceFactory.getControllerResource();
                }
            };
        }
        return processGroup;
    }

    public Resource getResource() {
        return ResourceFactory.getComponentResource((ResourceType)ResourceType.ControllerService, (String)this.getIdentifier(), (String)this.getName());
    }

    public boolean isRestricted() {
        return this.getControllerServiceImplementation().getClass().isAnnotationPresent(Restricted.class);
    }

    public Class<?> getComponentClass() {
        return this.getControllerServiceImplementation().getClass();
    }

    public boolean isDeprecated() {
        return this.getControllerServiceImplementation().getClass().isAnnotationPresent(DeprecationNotice.class);
    }

    public ControllerService getControllerServiceImplementation() {
        return this.controllerServiceHolder.get().getImplementation();
    }

    public ControllerService getProxiedControllerService() {
        return this.controllerServiceHolder.get().getProxiedControllerService();
    }

    public ControllerServiceInvocationHandler getInvocationHandler() {
        return this.controllerServiceHolder.get().getInvocationHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setControllerServiceAndProxy(LoggableComponent<ControllerService> implementation, LoggableComponent<ControllerService> proxiedControllerService, ControllerServiceInvocationHandler invocationHandler) {
        AtomicBoolean atomicBoolean = this.active;
        synchronized (atomicBoolean) {
            if (this.isActive()) {
                throw new IllegalStateException("Cannot modify configuration of " + String.valueOf((Object)this) + " while service is active");
            }
            ControllerServiceDetails controllerServiceDetails = new ControllerServiceDetails(implementation, proxiedControllerService, invocationHandler);
            this.controllerServiceHolder.set(controllerServiceDetails);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(Set<URL> additionalUrls) throws ControllerServiceInstantiationException {
        AtomicBoolean atomicBoolean = this.active;
        synchronized (atomicBoolean) {
            String additionalResourcesFingerprint = ClassLoaderUtils.generateAdditionalUrlsFingerprint(additionalUrls, (String)this.determineClasloaderIsolationKey());
            this.setAdditionalResourcesFingerprint(additionalResourcesFingerprint);
            this.getReloadComponent().reload((ControllerServiceNode)this, this.getCanonicalClassName(), this.getBundleCoordinate(), additionalUrls);
        }
    }

    public void setProperties(Map<String, String> properties, boolean allowRemovalOfRequiredProperties, Set<String> sensitiveDynamicPropertyNames) {
        super.setProperties(properties, allowRemovalOfRequiredProperties, sensitiveDynamicPropertyNames);
        this.getReferences().findRecursiveReferences(ComponentNode.class).forEach(ComponentNode::reloadAdditionalResourcesIfNecessary);
    }

    public ProcessGroup getProcessGroup() {
        return this.processGroup;
    }

    public Optional<ProcessGroup> getParentProcessGroup() {
        return Optional.ofNullable(this.processGroup);
    }

    public void setProcessGroup(ProcessGroup group) {
        this.processGroup = group;
        LOG.debug("Resetting Validation State of {} due to setting process group", (Object)this);
        this.resetValidationState();
    }

    public ControllerServiceReference getReferences() {
        this.readLock.lock();
        try {
            StandardControllerServiceReference standardControllerServiceReference = new StandardControllerServiceReference(this, this.referencingComponents.stream().map(Tuple::getKey).collect(Collectors.toSet()));
            return standardControllerServiceReference;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReference(ComponentNode referencingComponent, PropertyDescriptor propertyDescriptor) {
        this.writeLock.lock();
        try {
            boolean added = this.referencingComponents.add((Tuple<ComponentNode, PropertyDescriptor>)new Tuple((Object)referencingComponent, (Object)propertyDescriptor));
            if (added) {
                LOG.debug("{} Added referencing component {} for property {}", new Object[]{this, referencingComponent, propertyDescriptor.getName()});
            } else {
                LOG.debug("{} Will not add referencing component {} for property {} because there is already a reference", new Object[]{this, referencingComponent, propertyDescriptor.getName()});
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateReference(ComponentNode referencingComponent, PropertyDescriptor propertyDescriptor) {
        this.writeLock.lock();
        try {
            Tuple updatedTuple = new Tuple((Object)referencingComponent, (Object)propertyDescriptor);
            for (Tuple<ComponentNode, PropertyDescriptor> tuple : this.referencingComponents) {
                if (!Objects.equals(tuple.getKey(), referencingComponent)) continue;
                updatedTuple = new Tuple((Object)((ComponentNode)tuple.getKey()), (Object)propertyDescriptor);
                LOG.debug("{} updating reference from component {} and property {}", new Object[]{this, referencingComponent, propertyDescriptor});
            }
            this.referencingComponents.remove(updatedTuple);
            this.referencingComponents.add((Tuple<ComponentNode, PropertyDescriptor>)updatedTuple);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected ParameterContext getParameterContext() {
        ProcessGroup processGroup = this.getProcessGroup();
        return processGroup == null ? null : processGroup.getParameterContext();
    }

    public List<ControllerServiceNode> getRequiredControllerServices() {
        HashSet<ControllerServiceNode> requiredServices = new HashSet<ControllerServiceNode>();
        ValidationContext validationContext = this.getValidationContext();
        for (Map.Entry entry : this.getEffectivePropertyValues().entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            Class controllerServiceDefinition = descriptor.getControllerServiceDefinition();
            String referenceId = (String)entry.getValue();
            if (controllerServiceDefinition == null || referenceId == null) continue;
            boolean dependencySatisfied = validationContext.isDependencySatisfied(descriptor, arg_0 -> ((StandardControllerServiceNode)this).getPropertyDescriptor(arg_0));
            if (dependencySatisfied) {
                ControllerServiceNode requiredServiceNode = this.serviceProvider.getControllerServiceNode(referenceId);
                if (requiredServiceNode == null) {
                    LOG.warn("Referenced Controller Service [{}] not found for Service [{}] Property [{}]", new Object[]{referenceId, this.getIdentifier(), descriptor.getName()});
                    continue;
                }
                requiredServices.add(requiredServiceNode);
                continue;
            }
            LOG.debug("Referenced Controller Service [{}] not required for Service [{}] Property [{}]", new Object[]{referenceId, this.getIdentifier(), descriptor.getName()});
        }
        return new ArrayList<ControllerServiceNode>(requiredServices);
    }

    public void removeReference(ComponentNode referencingComponent, PropertyDescriptor propertyDescriptor) {
        this.writeLock.lock();
        try {
            this.referencingComponents.remove(new Tuple((Object)referencingComponent, (Object)propertyDescriptor));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void verifyModifiable() throws IllegalStateException {
        ControllerServiceState state = this.getState();
        if (state == ControllerServiceState.DISABLING) {
            throw new IllegalStateException("Cannot modify configuration of " + String.valueOf((Object)this) + " because it is currently still disabling. Please wait for the service to fully disable before attempting to modify it.");
        }
        if (state != ControllerServiceState.DISABLED) {
            throw new IllegalStateException("Cannot modify configuration of " + String.valueOf((Object)this) + " because it is currently not disabled - it has a state of " + String.valueOf(state) + ". Please disable the Controller Service first.");
        }
    }

    public void verifyCanDelete() {
        if (this.getState() != ControllerServiceState.DISABLED) {
            throw new IllegalStateException(String.valueOf((Object)this) + " cannot be deleted because it is not disabled");
        }
    }

    public void verifyCanDisable() {
        this.verifyCanDisable(Collections.emptySet());
    }

    public void verifyCanDisable(Set<ControllerServiceNode> ignoreReferences) {
        if (!this.isActive()) {
            return;
        }
        ControllerServiceReference references = this.getReferences();
        HashSet<String> activeReferencesIdentifiers = new HashSet<String>();
        for (ComponentNode activeReference : references.getActiveReferences()) {
            if (ignoreReferences.contains(activeReference)) continue;
            activeReferencesIdentifiers.add(activeReference.getIdentifier());
        }
        if (!activeReferencesIdentifiers.isEmpty()) {
            throw new IllegalStateException(String.valueOf((Object)this) + " cannot be disabled because it is referenced by " + activeReferencesIdentifiers.size() + " components that are currently running: [" + StringUtils.join(activeReferencesIdentifiers, (String)", ") + "]");
        }
    }

    public void verifyCanEnable() {
        ControllerServiceState state = this.getState();
        switch (state) {
            case DISABLED: {
                return;
            }
            case DISABLING: {
                throw new IllegalStateException(String.valueOf((Object)this) + " cannot be enabled because it is not disabled - it has a state of " + String.valueOf(state));
            }
        }
        if (this.isReloadAdditionalResourcesNecessary()) {
            throw new IllegalStateException(String.valueOf((Object)this) + " cannot be enabled because additional resources are needed - it has a state of " + String.valueOf(state));
        }
    }

    public void verifyCanEnable(Set<ControllerServiceNode> ignoredReferences) {
        this.verifyCanEnable();
    }

    public void verifyCanUpdate() {
        ControllerServiceState state = this.getState();
        if (state != ControllerServiceState.DISABLED) {
            throw new IllegalStateException(String.valueOf((Object)this) + " cannot be updated because it is not disabled - it has a state of " + String.valueOf(state));
        }
    }

    public void verifyCanClearState() {
        this.verifyCanUpdate();
    }

    public String getComments() {
        return this.comment;
    }

    public void setComments(String comment) {
        this.comment = CharacterFilterUtils.filterInvalidXmlCharacters((String)comment);
    }

    public ControllerServiceState getState() {
        return this.stateTransition.getState();
    }

    public boolean isActive() {
        return this.active.get();
    }

    public boolean awaitEnabled(long timePeriod, TimeUnit timeUnit) throws InterruptedException {
        LOG.debug("Waiting up to {} {} for {} to be enabled", new Object[]{timePeriod, timeUnit, this});
        boolean enabled = this.stateTransition.awaitStateOrInvalid(ControllerServiceState.ENABLED, timePeriod, timeUnit);
        if (enabled) {
            LOG.debug("{} is enabled", (Object)this);
        } else {
            LOG.debug("After {} {}, {} is NOT enabled", new Object[]{timePeriod, timeUnit, this});
        }
        return enabled;
    }

    public boolean awaitDisabled(long timePeriod, TimeUnit timeUnit) throws InterruptedException {
        LOG.debug("Waiting up to {} {} for {} to be disabled", new Object[]{timePeriod, timeUnit, this});
        boolean disabled = this.stateTransition.awaitState(ControllerServiceState.DISABLED, timePeriod, timeUnit);
        if (disabled) {
            LOG.debug("{} is now disabled", (Object)this);
        } else {
            LOG.debug("After {} {}, {} is NOT disabled", new Object[]{timePeriod, timeUnit, this});
        }
        return disabled;
    }

    public void verifyCanPerformVerification() {
        ControllerServiceState state = this.getState();
        if (state != ControllerServiceState.DISABLED) {
            throw new IllegalStateException("Cannot perform verification because the " + String.valueOf((Object)this) + " is not disabled - it has a state of " + String.valueOf(state));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigVerificationResult> verifyConfiguration(ConfigurationContext context, ComponentLog logger, Map<String, String> variables, ExtensionManager extensionManager) {
        ArrayList<ConfigVerificationResult> results;
        block21: {
            results = new ArrayList<ConfigVerificationResult>();
            try {
                this.verifyCanPerformVerification();
                long startNanos = System.nanoTime();
                results.addAll(super.verifyConfig(context.getProperties(), context.getAnnotationData(), this.getProcessGroup() == null ? null : this.getProcessGroup().getParameterContext()));
                long validationComplete = System.nanoTime();
                if (!results.isEmpty() && results.stream().anyMatch(result -> result.getOutcome() == ConfigVerificationResult.Outcome.FAILED)) {
                    return results;
                }
                ControllerService controllerService = this.getControllerServiceImplementation();
                if (controllerService instanceof VerifiableControllerService) {
                    block20: {
                        LOG.debug("{} is a VerifiableControllerService. Will perform full verification of configuration.", (Object)this);
                        VerifiableControllerService verifiable = (VerifiableControllerService)controllerService;
                        boolean classpathDifferent = this.isClasspathDifferent(context.getProperties());
                        if (classpathDifferent) {
                            Bundle bundle = extensionManager.getBundle(this.getBundleCoordinate());
                            Set classpathUrls = this.getAdditionalClasspathResources(context.getProperties().keySet(), descriptor -> context.getProperty(descriptor).getValue());
                            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
                            String classLoaderIsolationKey = this.getClassLoaderIsolationKey((PropertyContext)context);
                            try (InstanceClassLoader detectedClassLoader = extensionManager.createInstanceClassLoader(this.getComponentType(), this.getIdentifier(), bundle, classpathUrls, false, classLoaderIsolationKey);){
                                Thread.currentThread().setContextClassLoader((ClassLoader)detectedClassLoader);
                                results.addAll(verifiable.verify(context, logger, variables));
                                break block20;
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(currentClassLoader);
                            }
                        }
                        try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ExtensionManager)extensionManager, (Class)controllerService.getClass(), (String)this.getIdentifier());){
                            results.addAll(verifiable.verify(context, logger, variables));
                        }
                    }
                    long validationNanos = validationComplete - startNanos;
                    long verificationNanos = System.nanoTime() - validationComplete;
                    LOG.debug("{} completed full configuration validation in {} plus {} for validation", new Object[]{this, FormatUtils.formatNanos((long)verificationNanos, (boolean)false), FormatUtils.formatNanos((long)validationNanos, (boolean)false)});
                    break block21;
                }
                LOG.debug("{} is not a VerifiableControllerService, so will not perform full verification of configuration. Validation took {}", (Object)this, (Object)FormatUtils.formatNanos((long)(validationComplete - startNanos), (boolean)false));
            }
            catch (Throwable t) {
                LOG.error("Failed to perform verification of Controller Service's configuration for {}", (Object)this, (Object)t);
                results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.FAILED).verificationStepName("Perform Verification").explanation("Encountered unexpected failure when attempting to perform verification: " + String.valueOf(t)).build());
            }
        }
        return results;
    }

    public boolean isValidationNecessary() {
        return switch (this.getState()) {
            case ControllerServiceState.DISABLED, ControllerServiceState.DISABLING -> true;
            case ControllerServiceState.ENABLING -> {
                if (this.getValidationStatus() != ValidationStatus.VALID) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public ValidationState performValidation(ValidationContext validationContext) {
        ValidationState state = super.performValidation(validationContext);
        if (state.getStatus() == ValidationStatus.INVALID) {
            this.stateTransition.signalInvalid();
        }
        return state;
    }

    protected List<ValidationResult> validateConfig() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> enable(final ScheduledExecutorService scheduler, final long administrativeYieldMillis, final boolean completeExceptionallyOnFailure) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (!this.stateTransition.transitionToEnabling(ControllerServiceState.DISABLED, future)) {
            future.complete(null);
            return future;
        }
        AtomicBoolean atomicBoolean = this.active;
        synchronized (atomicBoolean) {
            this.active.set(true);
        }
        final AtomicLong enablingDelay = new AtomicLong(0L);
        final AtomicLong validationDelay = new AtomicLong(0L);
        final ControllerServiceProvider controllerServiceProvider = this.serviceProvider;
        final StandardControllerServiceNode serviceNode = this;
        scheduler.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                StandardConfigurationContext configContext = new StandardConfigurationContext((ComponentNode)serviceNode, (ControllerServiceLookup)controllerServiceProvider, null);
                if (!StandardControllerServiceNode.this.isActive()) {
                    LOG.warn("Enabling {} stopped: no active status", (Object)serviceNode);
                    StandardControllerServiceNode.this.stateTransition.disable();
                    future.complete(null);
                    return;
                }
                StandardControllerServiceNode.this.performValidation();
                ValidationState validationState = StandardControllerServiceNode.this.getValidationState();
                ValidationStatus validationStatus = validationState.getStatus();
                if (validationStatus == ValidationStatus.VALID) {
                    LOG.debug("Enabling {} proceeding after performing validation", (Object)serviceNode);
                } else if (completeExceptionallyOnFailure) {
                    Collection errors = validationState.getValidationErrors();
                    String message = "Enabling %s failed: Validation Status [%s] Errors %s".formatted(new Object[]{serviceNode, validationStatus, errors});
                    future.completeExceptionally(new IllegalStateException(message));
                } else {
                    long selectedValidationDelay = StandardControllerServiceNode.this.getDelay(validationDelay, 1000L);
                    if (selectedValidationDelay > MAXIMUM_DELAY.toMillis()) {
                        Collection errors = validationState.getValidationErrors();
                        LOG.warn("Validation rescheduled in {} ms for {} Errors {}", new Object[]{selectedValidationDelay, serviceNode, errors});
                    }
                    try {
                        scheduler.schedule(this, selectedValidationDelay, TimeUnit.MILLISECONDS);
                        LOG.debug("Validation rescheduled in {} ms for {}", (Object)selectedValidationDelay, (Object)serviceNode);
                    }
                    catch (RejectedExecutionException e) {
                        LOG.error("Validation rescheduling rejected for {}", (Object)serviceNode, (Object)e);
                        Collection errors = validationState.getValidationErrors();
                        String message = "Enabling %s rejected: Validation Status [%s] Errors %s".formatted(new Object[]{serviceNode, validationStatus, errors});
                        future.completeExceptionally(new IllegalStateException(message));
                    }
                    return;
                }
                ControllerService controllerService = StandardControllerServiceNode.this.getControllerServiceImplementation();
                try {
                    boolean shouldEnable;
                    try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ExtensionManager)StandardControllerServiceNode.this.getExtensionManager(), (Class)controllerService.getClass(), (String)StandardControllerServiceNode.this.getIdentifier());){
                        ReflectionUtils.invokeMethodsWithAnnotation(OnEnabled.class, controllerService, configContext);
                    }
                    AtomicBoolean e = StandardControllerServiceNode.this.active;
                    synchronized (e) {
                        shouldEnable = StandardControllerServiceNode.this.active.get() && StandardControllerServiceNode.this.stateTransition.enable(StandardControllerServiceNode.this.getReferences());
                    }
                    if (!shouldEnable) {
                        LOG.info("Disabling {} after enabled due to disable action initiated", (Object)serviceNode);
                        StandardControllerServiceNode.this.invokeDisable(configContext);
                        StandardControllerServiceNode.this.stateTransition.disable();
                        future.complete(null);
                    } else {
                        LOG.info("Enabled {}", (Object)serviceNode);
                    }
                }
                catch (Exception e) {
                    if (completeExceptionallyOnFailure) {
                        future.completeExceptionally(e);
                    }
                    Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
                    SimpleProcessLogger componentLog = new SimpleProcessLogger(StandardControllerServiceNode.this.getIdentifier(), controllerService, (LoggingContext)new StandardLoggingContext((GroupedComponent)serviceNode));
                    componentLog.error("Failed to invoke @OnEnabled method", cause);
                    StandardControllerServiceNode.this.invokeDisable(configContext);
                    if (StandardControllerServiceNode.this.isActive()) {
                        long selectedEnablingDelay = StandardControllerServiceNode.this.getDelay(enablingDelay, administrativeYieldMillis);
                        scheduler.schedule(this, selectedEnablingDelay, TimeUnit.MILLISECONDS);
                    }
                    StandardControllerServiceNode.this.stateTransition.disable();
                }
            }
        });
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> disable(ScheduledExecutorService scheduler) {
        AtomicBoolean atomicBoolean = this.active;
        synchronized (atomicBoolean) {
            this.active.set(false);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        boolean transitioned = this.stateTransition.transitionToDisabling(ControllerServiceState.ENABLING, future);
        if (transitioned) {
            scheduler.execute(() -> {
                this.stateTransition.disable();
                for (ComponentNode component : this.getReferences().getReferencingComponents()) {
                    component.performValidation();
                }
            });
            return future;
        }
        if (this.stateTransition.transitionToDisabling(ControllerServiceState.ENABLED, future)) {
            StandardConfigurationContext configContext = new StandardConfigurationContext((ComponentNode)this, (ControllerServiceLookup)this.serviceProvider, null);
            scheduler.execute(() -> {
                try {
                    this.invokeDisable(configContext);
                }
                finally {
                    this.stateTransition.disable();
                    for (ComponentNode component : this.getReferences().getReferencingComponents()) {
                        component.performValidation();
                    }
                }
            });
        }
        return future;
    }

    private void invokeDisable(ConfigurationContext configContext) {
        ControllerService controllerService = this.getControllerServiceImplementation();
        try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ExtensionManager)this.getExtensionManager(), (Class)controllerService.getClass(), (String)this.getIdentifier());){
            ReflectionUtils.invokeMethodsWithAnnotation(OnDisabled.class, controllerService, configContext);
            LOG.debug("Successfully disabled {}", (Object)this);
        }
        catch (Exception e) {
            Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
            SimpleProcessLogger componentLog = new SimpleProcessLogger(this.getIdentifier(), controllerService, (LoggingContext)new StandardLoggingContext((GroupedComponent)this));
            componentLog.error("Failed to invoke @OnDisabled method due to {}", cause);
            LOG.error("Failed to invoke @OnDisabled method of {} due to {}", (Object)this.getControllerServiceImplementation(), (Object)cause.toString());
        }
    }

    public String getProcessGroupIdentifier() {
        ProcessGroup procGroup = this.getProcessGroup();
        return procGroup == null ? null : procGroup.getIdentifier();
    }

    public Optional<String> getVersionedComponentId() {
        return Optional.ofNullable(this.versionedComponentId.get());
    }

    public void setVersionedComponentId(String versionedComponentId) {
        boolean updated = false;
        while (!updated) {
            String currentId = this.versionedComponentId.get();
            if (currentId == null) {
                updated = this.versionedComponentId.compareAndSet(null, versionedComponentId);
                continue;
            }
            if (currentId.equals(versionedComponentId)) {
                return;
            }
            if (versionedComponentId == null) {
                updated = this.versionedComponentId.compareAndSet(currentId, null);
                continue;
            }
            throw new IllegalStateException(String.valueOf((Object)this) + " is already under version control");
        }
    }

    public String toString() {
        return "StandardControllerServiceNode[service=" + super.toString() + ", name=" + this.getName() + ", active=" + String.valueOf(this.active) + "]";
    }

    public ParameterLookup getParameterLookup() {
        return this.getParameterContext();
    }

    public LogLevel getBulletinLevel() {
        return this.bulletinLevel;
    }

    public synchronized void setBulletinLevel(LogLevel level) {
        if (level == null) {
            level = LogLevel.WARN;
        }
        LogRepositoryFactory.getRepository((String)this.getIdentifier()).setObservationLevel(level);
        this.bulletinLevel = level;
    }

    public void notifyPrimaryNodeChanged(PrimaryNodeState nodeState) {
        Class implementationClass = this.getControllerServiceImplementation().getClass();
        List<Method> methods = ReflectionUtils.findMethodsWithAnnotations(implementationClass, new Class[]{OnPrimaryNodeStateChange.class});
        if (methods.isEmpty()) {
            return;
        }
        try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ExtensionManager)this.getExtensionManager(), (Class)implementationClass, (String)this.getIdentifier());){
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnPrimaryNodeStateChange.class, (Object)this.getControllerServiceImplementation(), nodeState);
        }
    }

    public void migrateConfiguration(Map<String, String> originalPropertyValues, ControllerServiceFactory serviceFactory) {
        HashMap<String, String> effectiveValues = new HashMap<String, String>();
        originalPropertyValues.forEach((key, value) -> effectiveValues.put((String)key, this.mapRawValueToEffectiveValue((String)value)));
        StandardPropertyConfiguration propertyConfig = new StandardPropertyConfiguration(effectiveValues, originalPropertyValues, x$0 -> super.mapRawValueToEffectiveValue(x$0), this.toString(), serviceFactory);
        ControllerService implementation = this.getControllerServiceImplementation();
        try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ExtensionManager)this.getExtensionManager(), (Class)implementation.getClass(), (String)this.getIdentifier());){
            implementation.migrateProperties((PropertyConfiguration)propertyConfig);
        }
        catch (Exception e) {
            LOG.error("Failed to migrate Property Configuration for {}.", (Object)this, (Object)e);
        }
        if (propertyConfig.isModified()) {
            List<ControllerServiceCreationDetails> servicesCreated = propertyConfig.getCreatedServices();
            servicesCreated.forEach(arg_0 -> ((ControllerServiceFactory)serviceFactory).create(arg_0));
            this.overwriteProperties(propertyConfig.getRawProperties());
        }
    }

    protected void performFlowAnalysisOnThis() {
        this.getValidationContextFactory().getFlowAnalyzer().ifPresent(flowAnalyzer -> flowAnalyzer.analyzeControllerService((ControllerServiceNode)this));
    }

    private long getDelay(AtomicLong trackedDelay, long incrementalDelay) {
        long currentDelay = trackedDelay.get();
        long selectedDelay = currentDelay > MAXIMUM_DELAY.toMillis() ? currentDelay : trackedDelay.addAndGet(incrementalDelay);
        return selectedDelay;
    }
}

