/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.nifi.events.BulletinProcessingStrategy;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinQuery;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.ComponentType;
import org.apache.nifi.util.RingBuffer;

public class VolatileBulletinRepository
implements BulletinRepository {
    private static final int CONTROLLER_BUFFER_SIZE = 10;
    private static final int COMPONENT_BUFFER_SIZE = 5;
    private static final String CONTROLLER_BULLETIN_STORE_KEY = "CONTROLLER";
    private static final String SERVICE_BULLETIN_STORE_KEY = "SERVICE";
    private static final String REPORTING_TASK_BULLETIN_STORE_KEY = "REPORTING_TASK";
    private static final String FLOW_ANALYSIS_RULE_BULLETIN_STORE_KEY = "FLOW_ANALYSIS_RULE";
    private static final String FLOW_REGISTRY_CLIENT_STORE_KEY = "FLOW_REGISTRY_CLIENT";
    private static final String PARAMETER_PROVIDER_BULLETIN_STORE_KEY = "PARAMETER_PROVIDER";
    private final ConcurrentMap<String, ConcurrentMap<String, RingBuffer<Bulletin>>> bulletinStoreMap = new ConcurrentHashMap<String, ConcurrentMap<String, RingBuffer<Bulletin>>>();
    private final BulletinProcessingStrategy processingStrategy = new DefaultBulletinProcessingStrategy();
    private final AtomicLong maxId = new AtomicLong(-1L);

    public void addBulletin(Bulletin bulletin) {
        this.processingStrategy.update(bulletin);
        long bulletinId = bulletin.getId();
        this.maxId.getAndAccumulate(bulletinId, Math::max);
    }

    public long getMaxBulletinId() {
        return this.maxId.get();
    }

    public int getControllerBulletinCapacity() {
        return 10;
    }

    public int getComponentBulletinCapacity() {
        return 5;
    }

    public List<Bulletin> findBulletins(BulletinQuery bulletinQuery) {
        RingBuffer.Filter<Bulletin> filter = this.createFilter(bulletinQuery);
        TreeSet selected = new TreeSet();
        int max = bulletinQuery.getLimit() == null ? Integer.MAX_VALUE : bulletinQuery.getLimit();
        block0: for (ConcurrentMap componentMap : this.bulletinStoreMap.values()) {
            for (RingBuffer ringBuffer : componentMap.values()) {
                List bulletinsForComponent = ringBuffer.getSelectedElements(filter, max);
                selected.addAll(bulletinsForComponent);
                if ((max -= bulletinsForComponent.size()) > 0) continue;
                continue block0;
            }
        }
        return new ArrayList<Bulletin>(selected);
    }

    private RingBuffer.Filter<Bulletin> createFilter(BulletinQuery bulletinQuery) {
        long fiveMinutesAgo = System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(5L);
        return bulletin -> {
            if (bulletinQuery.getAfter() != null && bulletin.getId() <= bulletinQuery.getAfter()) {
                return false;
            }
            if (!(bulletinQuery.getGroupIdPattern() == null || bulletin.getGroupId() != null && bulletinQuery.getGroupIdPattern().matcher(bulletin.getGroupId()).find())) {
                return false;
            }
            if (!(bulletinQuery.getMessagePattern() == null || bulletin.getMessage() != null && bulletinQuery.getMessagePattern().matcher(bulletin.getMessage()).find())) {
                return false;
            }
            if (!(bulletinQuery.getNamePattern() == null || bulletin.getSourceName() != null && bulletinQuery.getNamePattern().matcher(bulletin.getSourceName()).find())) {
                return false;
            }
            if (bulletin.getTimestamp().getTime() < fiveMinutesAgo) {
                return false;
            }
            if (!(bulletinQuery.getSourceIdPattern() == null || bulletin.getSourceId() != null && bulletinQuery.getSourceIdPattern().matcher(bulletin.getSourceId()).find())) {
                return false;
            }
            return bulletinQuery.getSourceType() == null || bulletin.getSourceType() != null && bulletinQuery.getSourceType().equals((Object)bulletin.getSourceType());
        };
    }

    public List<Bulletin> findBulletinsForSource(String sourceId, String groupId) {
        BulletinQuery bulletinQuery = new BulletinQuery.Builder().sourceIdMatches(Pattern.quote(sourceId)).groupIdMatches(Pattern.quote(groupId)).limit(Integer.valueOf(5)).build();
        ConcurrentMap componentMap = (ConcurrentMap)this.bulletinStoreMap.get(groupId);
        if (componentMap == null) {
            return Collections.emptyList();
        }
        return this.findBulletinsForSource(sourceId, bulletinQuery, Collections.singleton(componentMap));
    }

    public List<Bulletin> findBulletinsForSource(String sourceId) {
        BulletinQuery bulletinQuery = new BulletinQuery.Builder().sourceIdMatches(Pattern.quote(sourceId)).limit(Integer.valueOf(5)).build();
        return this.findBulletinsForSource(sourceId, bulletinQuery, this.bulletinStoreMap.values());
    }

    private List<Bulletin> findBulletinsForSource(String sourceId, BulletinQuery bulletinQuery, Collection<ConcurrentMap<String, RingBuffer<Bulletin>>> bulletinStoreMaps) {
        RingBuffer.Filter<Bulletin> filter = this.createFilter(bulletinQuery);
        int max = bulletinQuery.getLimit() == null ? Integer.MAX_VALUE : bulletinQuery.getLimit();
        for (ConcurrentMap<String, RingBuffer<Bulletin>> componentMap : bulletinStoreMaps) {
            RingBuffer ringBuffer = (RingBuffer)componentMap.get(sourceId);
            if (ringBuffer == null) continue;
            List bulletinsForComponent = ringBuffer.getSelectedElements(filter, max);
            Collections.sort(bulletinsForComponent);
            return bulletinsForComponent;
        }
        return Collections.emptyList();
    }

    public List<Bulletin> findBulletinsForGroupBySource(String groupId) {
        return this.findBulletinsForGroupBySource(groupId, 5);
    }

    public List<Bulletin> findBulletinsForGroupBySource(String groupId, int maxPerComponent) {
        long fiveMinutesAgo = System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(5L);
        ConcurrentMap componentMap = (ConcurrentMap)this.bulletinStoreMap.get(groupId);
        if (componentMap == null) {
            return Collections.emptyList();
        }
        ArrayList<Bulletin> allComponentBulletins = new ArrayList<Bulletin>();
        for (RingBuffer ringBuffer : componentMap.values()) {
            allComponentBulletins.addAll(ringBuffer.getSelectedElements(bulletin -> bulletin.getTimestamp().getTime() >= fiveMinutesAgo, maxPerComponent));
        }
        return allComponentBulletins;
    }

    public List<Bulletin> findBulletinsForController() {
        return this.findBulletinsForController(10);
    }

    public List<Bulletin> findBulletinsForController(int max) {
        RingBuffer buffer;
        long fiveMinutesAgo = System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(5L);
        RingBuffer.Filter filter = bulletin -> bulletin.getTimestamp().getTime() >= fiveMinutesAgo;
        ArrayList<Bulletin> controllerBulletins = new ArrayList<Bulletin>();
        ConcurrentMap controllerBulletinMap = (ConcurrentMap)this.bulletinStoreMap.get(CONTROLLER_BULLETIN_STORE_KEY);
        if (controllerBulletinMap != null && (buffer = (RingBuffer)controllerBulletinMap.get(CONTROLLER_BULLETIN_STORE_KEY)) != null) {
            controllerBulletins.addAll(buffer.getSelectedElements(filter, max));
        }
        Collections.sort(controllerBulletins);
        if (controllerBulletins.size() > max) {
            return controllerBulletins.subList(0, max);
        }
        return controllerBulletins;
    }

    private List<RingBuffer<Bulletin>> getBulletinBuffers(Bulletin bulletin) {
        RingBuffer existingBuffer;
        RingBuffer bulletinBuffer;
        ConcurrentMap existing;
        String storageKey = this.getBulletinStoreKey(bulletin);
        ConcurrentMap<String, RingBuffer> componentMap = (ConcurrentHashMap)this.bulletinStoreMap.get(storageKey);
        if (componentMap == null && (existing = (ConcurrentMap)this.bulletinStoreMap.putIfAbsent(storageKey, componentMap = new ConcurrentHashMap())) != null) {
            componentMap = existing;
        }
        ArrayList<RingBuffer<Bulletin>> buffers = new ArrayList<RingBuffer<Bulletin>>(2);
        if (this.isControllerBulletin(bulletin)) {
            bulletinBuffer = (RingBuffer)componentMap.get(CONTROLLER_BULLETIN_STORE_KEY);
            if (bulletinBuffer == null && (existingBuffer = componentMap.putIfAbsent(CONTROLLER_BULLETIN_STORE_KEY, bulletinBuffer = new RingBuffer(10))) != null) {
                bulletinBuffer = existingBuffer;
            }
            buffers.add((RingBuffer<Bulletin>)bulletinBuffer);
        }
        if (bulletin.getSourceType() != ComponentType.FLOW_CONTROLLER) {
            bulletinBuffer = (RingBuffer)componentMap.get(bulletin.getSourceId());
            if (bulletinBuffer == null) {
                bulletinBuffer = new RingBuffer(5);
                existingBuffer = componentMap.putIfAbsent(bulletin.getSourceId(), bulletinBuffer);
                if (existingBuffer != null) {
                    bulletinBuffer = existingBuffer;
                }
            }
            buffers.add((RingBuffer<Bulletin>)bulletinBuffer);
        }
        return buffers;
    }

    private String getBulletinStoreKey(Bulletin bulletin) {
        return switch (bulletin.getSourceType()) {
            case ComponentType.FLOW_CONTROLLER -> CONTROLLER_BULLETIN_STORE_KEY;
            case ComponentType.CONTROLLER_SERVICE -> SERVICE_BULLETIN_STORE_KEY;
            case ComponentType.REPORTING_TASK -> REPORTING_TASK_BULLETIN_STORE_KEY;
            case ComponentType.FLOW_ANALYSIS_RULE -> FLOW_ANALYSIS_RULE_BULLETIN_STORE_KEY;
            case ComponentType.PARAMETER_PROVIDER -> PARAMETER_PROVIDER_BULLETIN_STORE_KEY;
            case ComponentType.FLOW_REGISTRY_CLIENT -> FLOW_REGISTRY_CLIENT_STORE_KEY;
            default -> bulletin.getGroupId();
        };
    }

    private boolean isControllerBulletin(Bulletin bulletin) {
        return switch (bulletin.getSourceType()) {
            case ComponentType.FLOW_CONTROLLER, ComponentType.CONTROLLER_SERVICE, ComponentType.REPORTING_TASK, ComponentType.FLOW_ANALYSIS_RULE, ComponentType.PARAMETER_PROVIDER, ComponentType.FLOW_REGISTRY_CLIENT -> true;
            default -> false;
        };
    }

    private class DefaultBulletinProcessingStrategy
    implements BulletinProcessingStrategy {
        private DefaultBulletinProcessingStrategy() {
        }

        public void update(Bulletin bulletin) {
            for (RingBuffer<Bulletin> bulletinBuffer : VolatileBulletinRepository.this.getBulletinBuffers(bulletin)) {
                bulletinBuffer.add((Object)bulletin);
            }
        }
    }
}

