/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.logging.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogMessage;
import org.apache.nifi.logging.LogObserver;
import org.apache.nifi.logging.LogRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class StandardLogRepository
implements LogRepository {
    private final Map<LogLevel, Collection<LogObserver>> observersPerLogLevel = new ConcurrentHashMap<LogLevel, Collection<LogObserver>>();
    private final Set<LogObserver> observers = new HashSet<LogObserver>();
    private final Lock lock = new ReentrantLock();
    private final Logger logger = LoggerFactory.getLogger(StandardLogRepository.class);
    private volatile ComponentLog componentLogger;

    public void addLogMessage(LogMessage logMessage) {
        LogLevel logLevel = logMessage.getLogLevel();
        Collection<LogObserver> logObservers = this.observersPerLogLevel.get(logLevel);
        if (logObservers != null) {
            for (LogObserver observer : logObservers) {
                try {
                    observer.onLogMessage(logMessage);
                }
                catch (Exception observerThrowable) {
                    this.logger.error("Failed to pass log message to Observer {}", (Object)observer, (Object)observerThrowable);
                }
            }
        }
    }

    public void addLogMessage(LogLevel level, String format, Object[] params) {
        Optional<String> flowFileUuid = this.getFirstFlowFileUuidFromObjects(params);
        this.simplifyArgs(params);
        String formattedMessage = MessageFormatter.arrayFormat((String)format, (Object[])params).getMessage();
        LogMessage logMessage = new LogMessage.Builder(System.currentTimeMillis(), level).message(formattedMessage).flowFileUuid((String)flowFileUuid.orElse(null)).createLogMessage();
        this.addLogMessage(logMessage);
    }

    public void addLogMessage(LogLevel level, String format, Object[] params, Throwable t) {
        Optional<String> flowFileUuid = this.getFirstFlowFileUuidFromObjects(params);
        this.simplifyArgs(params);
        String formattedMessage = MessageFormatter.arrayFormat((String)format, (Object[])params, (Throwable)t).getMessage();
        LogMessage logMessage = new LogMessage.Builder(System.currentTimeMillis(), level).message(formattedMessage).throwable(t).flowFileUuid((String)flowFileUuid.orElse(null)).createLogMessage();
        this.addLogMessage(logMessage);
    }

    private Optional<String> getFirstFlowFileUuidFromObjects(Object[] params) {
        int flowFileCount = 0;
        FlowFile flowFileFound = null;
        for (Object param : params) {
            if (!(param instanceof FlowFile)) continue;
            if (++flowFileCount > 1) {
                return Optional.empty();
            }
            flowFileFound = (FlowFile)param;
        }
        return Optional.ofNullable(flowFileFound).map(ff -> ff.getAttribute(CoreAttributes.UUID.key()));
    }

    private void simplifyArgs(Object[] params) {
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.simplifyArg(params[i]);
        }
    }

    private Object simplifyArg(Object param) {
        if (param instanceof Throwable) {
            return ((Throwable)param).getLocalizedMessage();
        }
        if (param instanceof FlowFile) {
            FlowFile flowFile = (FlowFile)param;
            return "FlowFile[filename=" + flowFile.getAttribute(CoreAttributes.FILENAME.key()) + "]";
        }
        return param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObservationLevel(LogLevel level) {
        this.lock.lock();
        try {
            HashSet<LogObserver> observersCopy = new HashSet<LogObserver>(this.observers);
            this.observers.clear();
            this.observersPerLogLevel.clear();
            for (LogObserver observer : observersCopy) {
                this.addObserver(level, observer);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(LogLevel minimumLevel, LogObserver observer) {
        this.lock.lock();
        try {
            LogLevel[] allLevels = LogLevel.values();
            for (int i = minimumLevel.ordinal(); i < allLevels.length; ++i) {
                if (i == LogLevel.NONE.ordinal()) continue;
                Collection collection = this.observersPerLogLevel.computeIfAbsent(allLevels[i], k -> new ArrayList());
                collection.add(observer);
            }
            this.observers.add(observer);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeAllObservers() {
        this.lock.lock();
        try {
            this.observersPerLogLevel.clear();
            this.observers.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setLogger(ComponentLog componentLogger) {
        this.componentLogger = componentLogger;
    }

    public ComponentLog getLogger() {
        return this.componentLogger;
    }

    private boolean hasObserver(LogLevel logLevel) {
        Collection<LogObserver> logLevelObservers = this.observersPerLogLevel.get(logLevel);
        return logLevelObservers != null && !logLevelObservers.isEmpty();
    }

    public boolean isDebugEnabled() {
        return this.hasObserver(LogLevel.DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.hasObserver(LogLevel.INFO);
    }

    public boolean isWarnEnabled() {
        return this.hasObserver(LogLevel.WARN);
    }

    public boolean isErrorEnabled() {
        return this.hasObserver(LogLevel.ERROR);
    }
}

