/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.reporting;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.annotation.configuration.DefaultSchedule;
import org.apache.nifi.annotation.notification.OnPrimaryNodeStateChange;
import org.apache.nifi.annotation.notification.PrimaryNodeState;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.validation.ValidationState;
import org.apache.nifi.components.validation.ValidationStatus;
import org.apache.nifi.components.validation.ValidationTrigger;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractComponentNode;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.LoggableComponent;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ReloadComponent;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.TerminationAwareLogger;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.reporting.ReportingTaskDetails;
import org.apache.nifi.controller.reporting.ReportingTaskInstantiationException;
import org.apache.nifi.controller.scheduling.LifecycleState;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.migration.ControllerServiceCreationDetails;
import org.apache.nifi.migration.ControllerServiceFactory;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.migration.StandardPropertyConfiguration;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.InstanceClassLoader;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.reporting.VerifiableReportingTask;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.CharacterFilterUtils;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.ReflectionUtils;
import org.apache.nifi.util.file.classloader.ClassLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReportingTaskNode
extends AbstractComponentNode
implements ReportingTaskNode {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReportingTaskNode.class);
    private final AtomicReference<ReportingTaskDetails> reportingTaskRef;
    private final ProcessScheduler processScheduler;
    private final ControllerServiceLookup serviceLookup;
    private final AtomicReference<SchedulingStrategy> schedulingStrategy = new AtomicReference<SchedulingStrategy>(SchedulingStrategy.TIMER_DRIVEN);
    private final AtomicReference<String> schedulingPeriod = new AtomicReference<String>("5 mins");
    private volatile String comment;
    private volatile ScheduledState scheduledState = ScheduledState.STOPPED;

    public AbstractReportingTaskNode(LoggableComponent<ReportingTask> reportingTask, String id, ControllerServiceProvider controllerServiceProvider, ProcessScheduler processScheduler, ValidationContextFactory validationContextFactory, ReloadComponent reloadComponent, ExtensionManager extensionManager, ValidationTrigger validationTrigger) {
        this(reportingTask, id, controllerServiceProvider, processScheduler, validationContextFactory, ((ReportingTask)reportingTask.getComponent()).getClass().getSimpleName(), ((ReportingTask)reportingTask.getComponent()).getClass().getCanonicalName(), reloadComponent, extensionManager, validationTrigger, false);
    }

    public AbstractReportingTaskNode(LoggableComponent<ReportingTask> reportingTask, String id, ControllerServiceProvider controllerServiceProvider, ProcessScheduler processScheduler, ValidationContextFactory validationContextFactory, String componentType, String componentCanonicalClass, ReloadComponent reloadComponent, ExtensionManager extensionManager, ValidationTrigger validationTrigger, boolean isExtensionMissing) {
        super(id, validationContextFactory, controllerServiceProvider, componentType, componentCanonicalClass, reloadComponent, extensionManager, validationTrigger, isExtensionMissing);
        this.reportingTaskRef = new AtomicReference<ReportingTaskDetails>(new ReportingTaskDetails(reportingTask));
        this.processScheduler = processScheduler;
        this.serviceLookup = controllerServiceProvider;
        Class reportingClass = ((ReportingTask)reportingTask.getComponent()).getClass();
        DefaultSchedule dsc = reportingClass.getAnnotation(DefaultSchedule.class);
        if (dsc != null) {
            try {
                this.setSchedulingStrategy(dsc.strategy());
            }
            catch (Throwable ex) {
                LOG.error("Error while setting scheduling strategy from DefaultSchedule annotation", ex);
            }
            try {
                this.setSchedulingPeriod(dsc.period());
            }
            catch (Throwable ex) {
                this.setSchedulingStrategy(SchedulingStrategy.TIMER_DRIVEN);
                LOG.error("Error while setting scheduling period from DefaultSchedule annotation", ex);
            }
        }
    }

    public ConfigurableComponent getComponent() {
        return this.reportingTaskRef.get().getReportingTask();
    }

    public BundleCoordinate getBundleCoordinate() {
        return this.reportingTaskRef.get().getBundleCoordinate();
    }

    public TerminationAwareLogger getLogger() {
        return this.reportingTaskRef.get().getComponentLog();
    }

    public void setSchedulingStrategy(SchedulingStrategy schedulingStrategy) {
        this.schedulingStrategy.set(schedulingStrategy);
    }

    public SchedulingStrategy getSchedulingStrategy() {
        return this.schedulingStrategy.get();
    }

    public String getSchedulingPeriod() {
        return this.schedulingPeriod.get();
    }

    public long getSchedulingPeriod(TimeUnit timeUnit) {
        return FormatUtils.getTimeDuration((String)this.schedulingPeriod.get(), (TimeUnit)timeUnit);
    }

    public void setSchedulingPeriod(String schedulingPeriod) {
        this.schedulingPeriod.set(schedulingPeriod);
    }

    public ReportingTask getReportingTask() {
        return this.reportingTaskRef.get().getReportingTask();
    }

    public void setReportingTask(LoggableComponent<ReportingTask> reportingTask) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify configuration of " + String.valueOf((Object)this) + " while Reporting Task is running");
        }
        this.reportingTaskRef.set(new ReportingTaskDetails(reportingTask));
    }

    public void reload(Set<URL> additionalUrls) throws ReportingTaskInstantiationException {
        String additionalResourcesFingerprint = ClassLoaderUtils.generateAdditionalUrlsFingerprint(additionalUrls, (String)this.determineClasloaderIsolationKey());
        this.setAdditionalResourcesFingerprint(additionalResourcesFingerprint);
        this.getReloadComponent().reload((ReportingTaskNode)this, this.getCanonicalClassName(), this.getBundleCoordinate(), additionalUrls);
    }

    public boolean isRunning() {
        return this.processScheduler.isScheduled((Object)this) || this.processScheduler.getActiveThreadCount((Object)this) > 0;
    }

    public boolean isValidationNecessary() {
        return !this.processScheduler.isScheduled((Object)this) || this.getValidationStatus() != ValidationStatus.VALID;
    }

    public int getActiveThreadCount() {
        return this.processScheduler.getActiveThreadCount((Object)this);
    }

    public ConfigurationContext getConfigurationContext() {
        return new StandardConfigurationContext((ComponentNode)this, this.serviceLookup, this.getSchedulingPeriod());
    }

    public void verifyModifiable() throws IllegalStateException {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify " + String.valueOf((Object)this) + " while the Reporting Task is running");
        }
    }

    public ScheduledState getScheduledState() {
        return this.scheduledState;
    }

    public void setScheduledState(ScheduledState state) {
        this.scheduledState = state;
    }

    public boolean isDisabled() {
        return this.scheduledState == ScheduledState.DISABLED;
    }

    public String getComments() {
        return this.comment;
    }

    public void setComments(String comment) {
        this.comment = CharacterFilterUtils.filterInvalidXmlCharacters((String)comment);
    }

    public void verifyCanDelete() {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot delete " + String.valueOf((Object)this) + " because it is currently running");
        }
    }

    public void verifyCanDisable() {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot disable " + String.valueOf((Object)this) + " because it is currently running");
        }
        if (this.isDisabled()) {
            throw new IllegalStateException("Cannot disable " + String.valueOf((Object)this) + " because it is already disabled");
        }
    }

    public void verifyCanEnable() {
        if (!this.isDisabled()) {
            throw new IllegalStateException("Cannot enable " + String.valueOf((Object)this) + " because it is not disabled");
        }
    }

    public void verifyCanStart() {
        if (this.isDisabled()) {
            throw new IllegalStateException("Cannot start " + String.valueOf((Object)this) + " because it is currently disabled");
        }
        ValidationState validationState = this.getValidationState();
        if (validationState.getStatus() == ValidationStatus.INVALID) {
            throw new IllegalStateException("Cannot start " + String.valueOf((Object)this) + " because it is invalid with the following validation errors: " + String.valueOf(validationState.getValidationErrors()));
        }
    }

    public void verifyCanStop() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Cannot stop " + String.valueOf((Object)this) + " because it is not running");
        }
    }

    public void verifyCanUpdate() {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot update " + String.valueOf((Object)this) + " because it is currently running");
        }
    }

    public void verifyCanClearState() {
        this.verifyCanUpdate();
    }

    public void verifyCanStart(Set<ControllerServiceNode> ignoredReferences) {
        switch (this.getScheduledState()) {
            case DISABLED: {
                throw new IllegalStateException(String.valueOf((Object)this) + " cannot be started because it is disabled");
            }
            case RUNNING: {
                throw new IllegalStateException(String.valueOf((Object)this) + " cannot be started because it is already running");
            }
        }
        int activeThreadCount = this.getActiveThreadCount();
        if (activeThreadCount > 0) {
            throw new IllegalStateException(String.valueOf((Object)this) + " cannot be started because it has " + activeThreadCount + " active threads already");
        }
        Collection validationResults = this.getValidationErrors(ignoredReferences);
        if (!validationResults.isEmpty()) {
            throw new IllegalStateException(String.valueOf((Object)this) + " cannot be started because it is not currently valid");
        }
    }

    public String toString() {
        return "ReportingTask[id=" + this.getIdentifier() + ", name=" + this.getName() + "]";
    }

    public String getProcessGroupIdentifier() {
        return null;
    }

    public ParameterLookup getParameterLookup() {
        return ParameterLookup.EMPTY;
    }

    public void verifyCanPerformVerification() {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot perform verification of " + String.valueOf((Object)this) + " because Reporting Task is not fully stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigVerificationResult> verifyConfiguration(ConfigurationContext context, ComponentLog logger, ExtensionManager extensionManager) {
        ArrayList<ConfigVerificationResult> results;
        block21: {
            results = new ArrayList<ConfigVerificationResult>();
            try {
                this.verifyCanPerformVerification();
                long startNanos = System.nanoTime();
                results.addAll(super.verifyConfig(context.getProperties(), context.getAnnotationData(), null));
                long validationComplete = System.nanoTime();
                if (!results.isEmpty() && results.stream().anyMatch(result -> result.getOutcome() == ConfigVerificationResult.Outcome.FAILED)) {
                    return results;
                }
                ReportingTask reportingTask = this.getReportingTask();
                if (reportingTask instanceof VerifiableReportingTask) {
                    block20: {
                        logger.debug("{} is a VerifiableReportingTask. Will perform full verification of configuration.", new Object[]{this});
                        VerifiableReportingTask verifiable = (VerifiableReportingTask)reportingTask;
                        boolean classpathDifferent = this.isClasspathDifferent(context.getProperties());
                        if (classpathDifferent) {
                            Bundle bundle = extensionManager.getBundle(this.getBundleCoordinate());
                            Set classpathUrls = this.getAdditionalClasspathResources(context.getProperties().keySet(), descriptor -> context.getProperty(descriptor).getValue());
                            String classloaderIsolationKey = this.getClassLoaderIsolationKey((PropertyContext)context);
                            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
                            try (InstanceClassLoader detectedClassLoader = extensionManager.createInstanceClassLoader(this.getComponentType(), this.getIdentifier(), bundle, classpathUrls, false, classloaderIsolationKey);){
                                Thread.currentThread().setContextClassLoader((ClassLoader)detectedClassLoader);
                                results.addAll(verifiable.verify(context, logger));
                                break block20;
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(currentClassLoader);
                            }
                        }
                        try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ExtensionManager)extensionManager, (Class)reportingTask.getClass(), (String)this.getIdentifier());){
                            results.addAll(verifiable.verify(context, logger));
                        }
                    }
                    long validationNanos = validationComplete - startNanos;
                    long verificationNanos = System.nanoTime() - validationComplete;
                    logger.debug("{} completed full configuration validation in {} plus {} for validation", new Object[]{this, FormatUtils.formatNanos((long)verificationNanos, (boolean)false), FormatUtils.formatNanos((long)validationNanos, (boolean)false)});
                    break block21;
                }
                logger.debug("{} is not a VerifiableReportingTask, so will not perform full verification of configuration. Validation took {}", new Object[]{this, FormatUtils.formatNanos((long)(validationComplete - startNanos), (boolean)false)});
            }
            catch (Throwable t) {
                logger.error("Failed to perform verification of Reporting Task's configuration for {}", new Object[]{this, t});
                results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.FAILED).verificationStepName("Perform Verification").explanation("Encountered unexpected failure when attempting to perform verification: " + String.valueOf(t)).build());
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPrimaryNodeChanged(PrimaryNodeState nodeState, LifecycleState lifecycleState) {
        Class taskClass = this.getReportingTask().getClass();
        List<Method> methods = ReflectionUtils.findMethodsWithAnnotations(taskClass, new Class[]{OnPrimaryNodeStateChange.class});
        if (methods.isEmpty()) {
            return;
        }
        lifecycleState.incrementActiveThreadCount(null);
        try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ExtensionManager)this.getExtensionManager(), (Class)taskClass, (String)this.getIdentifier());){
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnPrimaryNodeStateChange.class, (Object)this.getReportingTask(), nodeState);
        }
        finally {
            lifecycleState.decrementActiveThreadCount();
        }
    }

    public Optional<ProcessGroup> getParentProcessGroup() {
        return Optional.empty();
    }

    public void migrateConfiguration(Map<String, String> originalPropertyValues, ControllerServiceFactory serviceFactory) {
        ReportingTask task = this.getReportingTask();
        HashMap<String, String> effectiveValues = new HashMap<String, String>();
        originalPropertyValues.forEach((key, value) -> effectiveValues.put((String)key, this.mapRawValueToEffectiveValue((String)value)));
        StandardPropertyConfiguration propertyConfig = new StandardPropertyConfiguration(effectiveValues, originalPropertyValues, x$0 -> this.mapRawValueToEffectiveValue((String)x$0), this.toString(), serviceFactory);
        try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ExtensionManager)this.getExtensionManager(), (Class)task.getClass(), (String)this.getIdentifier());){
            task.migrateProperties((PropertyConfiguration)propertyConfig);
        }
        catch (Exception e) {
            LOG.error("Failed to migrate Property Configuration for {}.", (Object)this, (Object)e);
        }
        if (propertyConfig.isModified()) {
            List<ControllerServiceCreationDetails> servicesCreated = propertyConfig.getCreatedServices();
            servicesCreated.forEach(arg_0 -> ((ControllerServiceFactory)serviceFactory).create(arg_0));
            this.overwriteProperties(propertyConfig.getRawProperties());
        }
    }
}

