/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.framework.configuration;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.flow.FlowElection;
import org.apache.nifi.cluster.coordination.flow.PopularVoteFlowElection;
import org.apache.nifi.cluster.coordination.heartbeat.ClusterProtocolHeartbeatMonitor;
import org.apache.nifi.cluster.coordination.heartbeat.HeartbeatMonitor;
import org.apache.nifi.cluster.coordination.node.NodeClusterCoordinator;
import org.apache.nifi.cluster.firewall.ClusterNodeFirewall;
import org.apache.nifi.cluster.firewall.impl.FileBasedClusterNodeFirewall;
import org.apache.nifi.cluster.protocol.NodeProtocolSender;
import org.apache.nifi.cluster.protocol.ProtocolListener;
import org.apache.nifi.cluster.protocol.impl.ClusterCoordinationProtocolSenderListener;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.controller.leader.election.LeaderElectionManager;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.revision.RevisionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ClusterCoordinatorConfiguration {
    private NiFiProperties properties;
    private ClusterCoordinationProtocolSenderListener protocolListener;
    private NodeProtocolSender nodeProtocolSender;
    private RevisionManager revisionManager;
    private EventReporter eventReporter;
    private LeaderElectionManager leaderElectionManager;
    private StateManagerProvider stateManagerProvider;

    @Autowired
    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    @Autowired
    public void setStateManagerProvider(StateManagerProvider stateManagerProvider) {
        this.stateManagerProvider = stateManagerProvider;
    }

    @Autowired
    public void setLeaderElectionManager(LeaderElectionManager leaderElectionManager) {
        this.leaderElectionManager = leaderElectionManager;
    }

    @Autowired
    public void setEventReporter(EventReporter eventReporter) {
        this.eventReporter = eventReporter;
    }

    @Autowired
    public void setRevisionManager(RevisionManager revisionManager) {
        this.revisionManager = revisionManager;
    }

    @Qualifier(value="nodeProtocolSender")
    @Autowired(required=false)
    public void setNodeProtocolSender(NodeProtocolSender nodeProtocolSender) {
        this.nodeProtocolSender = nodeProtocolSender;
    }

    @Autowired(required=false)
    public void setProtocolListener(ClusterCoordinationProtocolSenderListener protocolListener) {
        this.protocolListener = protocolListener;
    }

    @Bean
    public ClusterCoordinator clusterCoordinator() {
        NodeClusterCoordinator clusterCoordinator;
        if (this.properties.isClustered()) {
            try {
                clusterCoordinator = new NodeClusterCoordinator(this.protocolListener, this.eventReporter, this.leaderElectionManager, this.flowElection(), this.clusterFirewall(), this.revisionManager, this.properties, this.nodeProtocolSender, this.stateManagerProvider);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to load Cluster Coordinator", e);
            }
        } else {
            clusterCoordinator = null;
        }
        return clusterCoordinator;
    }

    @Bean
    public HeartbeatMonitor heartbeatMonitor() {
        ClusterCoordinator clusterCoordinator = this.clusterCoordinator();
        ClusterProtocolHeartbeatMonitor heartbeatMonitor = clusterCoordinator == null ? null : new ClusterProtocolHeartbeatMonitor(clusterCoordinator, (ProtocolListener)this.protocolListener, this.properties);
        return heartbeatMonitor;
    }

    private ClusterNodeFirewall clusterFirewall() {
        FileBasedClusterNodeFirewall firewall;
        File config = this.properties.getClusterNodeFirewallFile();
        File restoreDirectory = this.properties.getRestoreDirectory();
        if (config == null) {
            firewall = null;
        } else {
            try {
                firewall = new FileBasedClusterNodeFirewall(config, restoreDirectory);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to load Cluster Firewall configuration", e);
            }
        }
        return firewall;
    }

    private FlowElection flowElection() {
        String maxWaitTime = this.properties.getFlowElectionMaxWaitTime();
        long maxWaitMillis = FormatUtils.getTimeDuration((String)maxWaitTime, (TimeUnit)TimeUnit.MILLISECONDS);
        Integer maxNodes = this.properties.getFlowElectionMaxCandidates();
        return new PopularVoteFlowElection(maxWaitMillis, TimeUnit.MILLISECONDS, maxNodes);
    }
}

