/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleEntityEndpoint;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.PermissionsDtoMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.ControllerConfigurationEntity;

public class ControllerConfigurationEndpointMerger
extends AbstractSingleEntityEndpoint<ControllerConfigurationEntity> {
    public static final Pattern CONTROLLER_CONFIGURATION_URI_PATTERN = Pattern.compile("/nifi-api/controller/config");

    @Override
    protected Class<ControllerConfigurationEntity> getEntityClass() {
        return ControllerConfigurationEntity.class;
    }

    @Override
    protected void mergeResponses(ControllerConfigurationEntity clientEntity, Map<NodeIdentifier, ControllerConfigurationEntity> entityMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        entityMap.values().stream().forEach(controllerConfigurationDTO -> PermissionsDtoMerger.mergePermissions(clientEntity.getPermissions(), controllerConfigurationDTO.getPermissions()));
        if (!clientEntity.getPermissions().getCanRead().booleanValue() && clientEntity.getComponent() != null) {
            clientEntity.setComponent(null);
        }
    }

    @Override
    public boolean canHandle(URI uri, String method) {
        return ("GET".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method)) && CONTROLLER_CONFIGURATION_URI_PATTERN.matcher(uri.getPath()).matches();
    }
}

