/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.node.state;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.cluster.protocol.NodeIdentifier;

public class NodeIdentifierDescriptor {
    private String id;
    private String apiAddress;
    private int apiPort;
    private String socketAddress;
    private int socketPort;
    private String loadBalanceAddress;
    private int loadBalancePort;
    private String siteToSiteAddress;
    private Integer siteToSitePort;
    private Integer siteToSiteHttpApiPort;
    private Boolean siteToSiteSecure;
    private Set<String> nodeIdentities;
    private boolean localNodeIdentifier;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getApiAddress() {
        return this.apiAddress;
    }

    public void setApiAddress(String apiAddress) {
        this.apiAddress = apiAddress;
    }

    public int getApiPort() {
        return this.apiPort;
    }

    public void setApiPort(int apiPort) {
        this.apiPort = apiPort;
    }

    public String getSocketAddress() {
        return this.socketAddress;
    }

    public void setSocketAddress(String socketAddress) {
        this.socketAddress = socketAddress;
    }

    public int getSocketPort() {
        return this.socketPort;
    }

    public void setSocketPort(int socketPort) {
        this.socketPort = socketPort;
    }

    public String getLoadBalanceAddress() {
        return this.loadBalanceAddress;
    }

    public void setLoadBalanceAddress(String loadBalanceAddress) {
        this.loadBalanceAddress = loadBalanceAddress;
    }

    public int getLoadBalancePort() {
        return this.loadBalancePort;
    }

    public void setLoadBalancePort(int loadBalancePort) {
        this.loadBalancePort = loadBalancePort;
    }

    public String getSiteToSiteAddress() {
        return this.siteToSiteAddress;
    }

    public void setSiteToSiteAddress(String siteToSiteAddress) {
        this.siteToSiteAddress = siteToSiteAddress;
    }

    public Integer getSiteToSitePort() {
        return this.siteToSitePort;
    }

    public void setSiteToSitePort(Integer siteToSitePort) {
        this.siteToSitePort = siteToSitePort;
    }

    public Integer getSiteToSiteHttpApiPort() {
        return this.siteToSiteHttpApiPort;
    }

    public void setSiteToSiteHttpApiPort(Integer siteToSiteHttpApiPort) {
        this.siteToSiteHttpApiPort = siteToSiteHttpApiPort;
    }

    public Boolean getSiteToSiteSecure() {
        return this.siteToSiteSecure;
    }

    public void setSiteToSiteSecure(Boolean siteToSiteSecure) {
        this.siteToSiteSecure = siteToSiteSecure;
    }

    public Set<String> getNodeIdentities() {
        return this.nodeIdentities;
    }

    public void setNodeIdentities(Set<String> nodeIdentities) {
        this.nodeIdentities = Collections.unmodifiableSet(new HashSet<String>(nodeIdentities));
    }

    public boolean isLocalNodeIdentifier() {
        return this.localNodeIdentifier;
    }

    public void setLocalNodeIdentifier(boolean localNodeIdentifier) {
        this.localNodeIdentifier = localNodeIdentifier;
    }

    public static NodeIdentifierDescriptor fromNodeIdentifier(NodeIdentifier nodeId, boolean localNodeId) {
        NodeIdentifierDescriptor descriptor = new NodeIdentifierDescriptor();
        descriptor.setId(nodeId.getId());
        descriptor.setApiAddress(nodeId.getApiAddress());
        descriptor.setApiPort(nodeId.getApiPort());
        descriptor.setSocketAddress(nodeId.getSocketAddress());
        descriptor.setSocketPort(nodeId.getSocketPort());
        descriptor.setSiteToSiteAddress(nodeId.getSiteToSiteAddress());
        descriptor.setSiteToSitePort(nodeId.getSiteToSitePort());
        descriptor.setSiteToSiteHttpApiPort(nodeId.getSiteToSiteHttpApiPort());
        descriptor.setSiteToSiteSecure(nodeId.isSiteToSiteSecure());
        descriptor.setNodeIdentities(nodeId.getNodeIdentities());
        descriptor.setLoadBalanceAddress(nodeId.getLoadBalanceAddress());
        descriptor.setLoadBalancePort(nodeId.getLoadBalancePort());
        descriptor.setLocalNodeIdentifier(localNodeId);
        return descriptor;
    }

    public NodeIdentifier toNodeIdentifier() {
        return new NodeIdentifier(this.getId(), this.getApiAddress(), this.getApiPort(), this.getSocketAddress(), this.getSocketPort(), this.getLoadBalanceAddress(), this.getLoadBalancePort(), this.getSiteToSiteAddress(), this.getSiteToSitePort(), this.getSiteToSiteHttpApiPort(), this.getSiteToSiteSecure().booleanValue(), this.getNodeIdentities());
    }
}

