/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;

public interface ContentRepository {
    public void initialize(ResourceClaimManager var1) throws IOException;

    public void shutdown();

    public Set<String> getContainerNames();

    public long getContainerCapacity(String var1) throws IOException;

    public long getContainerUsableSpace(String var1) throws IOException;

    public String getContainerFileStoreName(String var1);

    public ContentClaim create(boolean var1) throws IOException;

    public int incrementClaimaintCount(ContentClaim var1);

    public int getClaimantCount(ContentClaim var1);

    public int decrementClaimantCount(ContentClaim var1);

    public boolean remove(ContentClaim var1);

    public ContentClaim clone(ContentClaim var1, boolean var2) throws IOException;

    public long merge(Collection<ContentClaim> var1, ContentClaim var2, byte[] var3, byte[] var4, byte[] var5) throws IOException;

    public long importFrom(Path var1, ContentClaim var2) throws IOException;

    public long importFrom(InputStream var1, ContentClaim var2) throws IOException;

    public long exportTo(ContentClaim var1, Path var2, boolean var3) throws IOException;

    public long exportTo(ContentClaim var1, Path var2, boolean var3, long var4, long var6) throws IOException;

    public long exportTo(ContentClaim var1, OutputStream var2) throws IOException;

    public long exportTo(ContentClaim var1, OutputStream var2, long var3, long var5) throws IOException;

    public long size(ContentClaim var1) throws IOException;

    public InputStream read(ContentClaim var1) throws IOException;

    public OutputStream write(ContentClaim var1) throws IOException;

    public void purge();

    public void cleanup();

    public boolean isAccessible(ContentClaim var1) throws IOException;

    default public Set<ResourceClaim> getActiveResourceClaims(String containerName) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public boolean isActiveResourceClaimsSupported() {
        return false;
    }
}

