/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.StandardEvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.literals.StringLiteralEvaluator;

public class ReplaceByPatternEvaluator
extends StringEvaluator {
    private final Evaluator<String> subject;
    private final Evaluator<String> search;
    private Map<String, Pattern> compiledPatterns = null;

    public ReplaceByPatternEvaluator(Evaluator<String> subject, Evaluator<String> search) {
        this.subject = subject;
        this.search = search;
        this.compiledPatterns = search instanceof StringLiteralEvaluator ? this.compilePatterns(search.evaluate(new StandardEvaluationContext(Collections.emptyMap())).getValue()) : null;
    }

    @Override
    public QueryResult<String> evaluate(EvaluationContext evaluationContext) {
        Map<String, Pattern> patterns;
        String subjectValue = this.subject.evaluate(evaluationContext).getValue();
        if (subjectValue == null) {
            return new StringQueryResult(null);
        }
        if (this.compiledPatterns == null) {
            String expression = this.search.evaluate(evaluationContext).getValue();
            if (expression == null) {
                return new StringQueryResult(subjectValue);
            }
            patterns = this.compilePatterns(expression);
        } else {
            patterns = this.compiledPatterns;
        }
        for (Map.Entry<String, Pattern> entry : patterns.entrySet()) {
            if (!entry.getValue().matcher(subjectValue).matches()) continue;
            return new StringQueryResult(entry.getKey());
        }
        return new StringQueryResult(subjectValue);
    }

    private Map<String, Pattern> compilePatterns(String argument) {
        String[] mappings;
        HashMap<String, Pattern> result = new HashMap<String, Pattern>();
        if (argument == null || argument.trim().isEmpty()) {
            return result;
        }
        for (String mapping : mappings = argument.split(",")) {
            String[] parts = mapping.trim().split(":");
            String streamPattern = parts[0];
            String mappedTo = parts[1];
            if (streamPattern == null || streamPattern.trim().isEmpty() || mappedTo == null || mappedTo.trim().isEmpty()) continue;
            try {
                result.put(mappedTo, Pattern.compile(streamPattern));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

