/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.server.codec;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.apache.nifi.distributed.cache.operations.CacheOperation;
import org.apache.nifi.distributed.cache.operations.MapOperation;
import org.apache.nifi.distributed.cache.server.codec.CacheRequestDecoder;
import org.apache.nifi.distributed.cache.server.protocol.MapCacheRequest;
import org.apache.nifi.logging.ComponentLog;

public class MapCacheRequestDecoder
extends CacheRequestDecoder {
    public MapCacheRequestDecoder(ComponentLog log, int maxReadSize, CacheOperation[] supportedOperations) {
        super(log, maxReadSize, supportedOperations);
    }

    @Override
    protected Optional<Object> readRequest(CacheOperation cacheOperation, ByteBuf byteBuf) {
        MapCacheRequest request = MapOperation.CONTAINS_KEY == cacheOperation ? this.readKeyRequest(cacheOperation, byteBuf) : (MapOperation.FETCH == cacheOperation ? this.readKeyRequest(cacheOperation, byteBuf) : (MapOperation.GET == cacheOperation ? this.readKeyRequest(cacheOperation, byteBuf) : (MapOperation.GET_AND_PUT_IF_ABSENT == cacheOperation ? this.readKeyValueRequest(cacheOperation, byteBuf) : (MapOperation.KEYSET == cacheOperation ? new MapCacheRequest(cacheOperation) : (MapOperation.REMOVE == cacheOperation ? this.readKeyRequest(cacheOperation, byteBuf) : (MapOperation.REMOVE_AND_GET == cacheOperation ? this.readKeyRequest(cacheOperation, byteBuf) : (MapOperation.REPLACE == cacheOperation ? this.readKeyRevisionValueRequest(cacheOperation, byteBuf) : (MapOperation.SUBMAP == cacheOperation ? this.readSubMapRequest(cacheOperation, byteBuf) : (MapOperation.PUT == cacheOperation ? this.readKeyValueRequest(cacheOperation, byteBuf) : (MapOperation.PUT_IF_ABSENT == cacheOperation ? this.readKeyValueRequest(cacheOperation, byteBuf) : new MapCacheRequest(cacheOperation)))))))))));
        return Optional.ofNullable(request);
    }

    private MapCacheRequest readKeyRequest(CacheOperation cacheOperation, ByteBuf byteBuf) {
        Optional<byte[]> key = this.readBytes(byteBuf);
        return key.map(bytes -> new MapCacheRequest(cacheOperation, (byte[])bytes)).orElse(null);
    }

    private MapCacheRequest readKeyValueRequest(CacheOperation cacheOperation, ByteBuf byteBuf) {
        MapCacheRequest mapCacheRequest;
        Optional<byte[]> key = this.readBytes(byteBuf);
        if (key.isPresent()) {
            Optional<byte[]> value = this.readBytes(byteBuf);
            mapCacheRequest = value.map(valueBytes -> new MapCacheRequest(cacheOperation, (byte[])key.get(), (byte[])valueBytes)).orElse(null);
        } else {
            mapCacheRequest = null;
        }
        return mapCacheRequest;
    }

    private MapCacheRequest readKeyRevisionValueRequest(CacheOperation cacheOperation, ByteBuf byteBuf) {
        MapCacheRequest mapCacheRequest;
        Optional<byte[]> key = this.readBytes(byteBuf);
        if (key.isPresent()) {
            OptionalLong revision = this.readLong(byteBuf);
            if (revision.isPresent()) {
                Optional<byte[]> value = this.readBytes(byteBuf);
                mapCacheRequest = value.map(valueBytes -> new MapCacheRequest(cacheOperation, (byte[])key.get(), revision.getAsLong(), (byte[])valueBytes)).orElse(null);
            } else {
                mapCacheRequest = null;
            }
        } else {
            mapCacheRequest = null;
        }
        return mapCacheRequest;
    }

    private MapCacheRequest readSubMapRequest(CacheOperation cacheOperation, ByteBuf byteBuf) {
        MapCacheRequest mapCacheRequest;
        OptionalInt keys = this.readInt(byteBuf);
        if (keys.isPresent()) {
            ArrayList<byte[]> subMapKeys = new ArrayList<byte[]>();
            for (int i = 0; i < keys.getAsInt(); ++i) {
                Optional<byte[]> key = this.readBytes(byteBuf);
                if (!key.isPresent()) {
                    subMapKeys.clear();
                    break;
                }
                subMapKeys.add(key.get());
            }
            mapCacheRequest = subMapKeys.isEmpty() ? null : new MapCacheRequest(cacheOperation, subMapKeys);
        } else {
            mapCacheRequest = null;
        }
        return mapCacheRequest;
    }
}

